/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockLocator;
import java.util.ArrayList;
import java.util.Objects;

public class BlockDiff {
    private final Block block_a;
    private final Block block_b;
    private static final int NO_DIFFERENCE = -1;
    private static final int LENGTH_DIFFERENCE = -2;
    private static final int MAX_RESULTS = 10;

    public BlockDiff(Block block_a, Block block_b) {
        this.block_a = block_a;
        this.block_b = block_b;
    }

    public DiffResult[] find() {
        return this.find(10);
    }

    public DiffResult[] find(int limit) {
        byte[] bytes_a = this.block_a.getBytes();
        byte[] bytes_b = this.block_b.getBytes();
        ArrayList<DiffResult> results = new ArrayList<DiffResult>();
        int start = 0;
        int position = this.findByteDifferencePosition(start, bytes_a, bytes_b);
        while ((limit < 0 || results.size() < limit) && position != -1) {
            BlockLocator.Result result_b;
            BlockLocator.Result result_a;
            int location = position;
            if (position == -2) {
                location = start;
            }
            if (Objects.equals(result_a = this.block_a.locateBlock(location), result_b = this.block_b.locateBlock(location))) break;
            DiffResult diffResult = new DiffResult(result_a, result_b);
            results.add(diffResult);
            if (result_a == null || result_b == null) break;
            start = location + result_a.block.countBytes() + 1;
            position = this.findByteDifferencePosition(start, bytes_a, bytes_b);
        }
        return results.toArray(new DiffResult[0]);
    }

    private int findByteDifferencePosition(int start, byte[] bytes1, byte[] bytes2) {
        int length = bytes1.length;
        if (length > bytes2.length) {
            length = bytes2.length;
        }
        for (int i = start; i < length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return i;
        }
        if (bytes1.length != bytes2.length) {
            return -2;
        }
        return -1;
    }

    public static String toString(DiffResult[] results) {
        if (results == null || results.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < results.length; ++i) {
            if (i != 0) {
                builder.append("\n");
            }
            builder.append(results[i]);
        }
        return builder.toString();
    }

    public static class DiffResult {
        public final BlockLocator.Result BLOCK_A;
        public final BlockLocator.Result BLOCK_B;

        DiffResult(BlockLocator.Result block_a, BlockLocator.Result block_b) {
            this.BLOCK_A = block_a;
            this.BLOCK_B = block_b;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BLOCK_A {");
            if (this.BLOCK_A != null) {
                builder.append(this.BLOCK_A.getMessage());
            } else {
                builder.append("null");
            }
            builder.append("}, BLOCK_B {");
            if (this.BLOCK_B != null) {
                builder.append(this.BLOCK_B.getMessage());
            } else {
                builder.append("null");
            }
            builder.append("}");
            return builder.toString();
        }
    }
}

