/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BlockContainer<T extends Block>
extends Block
implements BlockRefresh {
    protected void onPreRefresh() {
    }

    protected abstract void onRefreshed();

    @Override
    public final void refresh() {
        if (this.isNull()) {
            return;
        }
        this.onPreRefresh();
        this.refreshChildes();
        this.onRefreshed();
    }

    protected void refreshChildes() {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        for (Block item : childes) {
            if (!(item instanceof BlockRefresh)) continue;
            ((BlockRefresh)((Object)item)).refresh();
        }
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        int max = childes.length;
        for (int i = 0; i < max; ++i) {
            if (counter.FOUND) {
                return;
            }
            Block item = childes[i];
            if (item == null) continue;
            item.onCountUpTo(counter);
        }
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return 0;
        }
        int result = 0;
        for (Block item : childes) {
            if (item == null) continue;
            result += item.countBytes();
        }
        return result;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return null;
        }
        byte[] results = null;
        for (Block item : childes) {
            if (item == null) continue;
            results = BlockContainer.addBytes(results, item.getBytes());
        }
        return results;
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return 0;
        }
        int result = 0;
        for (Block item : childes) {
            if (item == null) continue;
            result += item.writeBytes(stream);
        }
        return result;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        for (Block item : childes) {
            if (item == null) continue;
            item.readBytes(reader);
        }
    }

    public abstract int getChildesCount();

    public abstract T[] getChildes();
}

