/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArrayCreator;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.common.ArraySupplier;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.ArraySort;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class BlockArray<T extends Block>
extends BlockContainer<T>
implements BlockArrayCreator<T>,
ArraySupplier<T> {
    private T[] elementData;
    private int mFreeSpace;
    private int mAllocateStep;

    public BlockArray() {
        this.elementData = this.newArrayInstance(0);
    }

    public BlockArray(T[] elementData) {
        this.elementData = elementData;
    }

    public void removeAllNull(int start) {
        this.removeAll(start, true);
    }

    public void removeAll(int start) {
        this.removeAll(start, false);
    }

    private void removeAll(int start, boolean check_null) {
        Block[] removeList = this.subArray(start);
        if (removeList.length == 0 || check_null && !BlockArray.isAllNull(removeList)) {
            return;
        }
        T[] elementData = this.elementData;
        for (Block item : removeList) {
            int index;
            if (item == null) continue;
            if (!item.isNull()) {
                item.setNull(true);
            }
            if ((index = item.getIndex()) < 0 || elementData[index] != item) continue;
            item.setIndex(-1);
            item.setParent(null);
            elementData[index] = null;
        }
        this.setSize(start);
    }

    private T[] subArray(int start) {
        return this.subArray(start, -1);
    }

    private T[] subArray(int start, int count) {
        T[] items = this.elementData;
        int length = items.length;
        if (start < 0) {
            start = 0;
        }
        if (start >= length) {
            return this.newArrayInstance(0);
        }
        int end = count;
        if (end < 0) {
            end = items.length;
        } else {
            end = start + count;
            if (end > length) {
                end = length;
            }
        }
        Block[] results = this.newArrayInstance(end - start);
        int index = 0;
        for (int i = start; i < end; ++i) {
            results[index] = items[i];
            ++index;
        }
        return results;
    }

    public Collection<T> listItems() {
        return this.listItems(false);
    }

    public Collection<T> listItems(final boolean skipNullBlocks) {
        this.trimAllocatedFreeSpace();
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockArray.this.iterator(skipNullBlocks);
            }

            @Override
            public boolean contains(Object o) {
                return BlockArray.this.contains(o);
            }

            @Override
            public int size() {
                return BlockArray.this.size();
            }
        };
    }

    @Override
    public T[] getChildes() {
        return this.elementData;
    }

    public void ensureSize(int size) {
        if (size <= this.size()) {
            return;
        }
        this.setSize(size);
    }

    @Deprecated
    public void setChildesCount(int size) {
        this.setSize(size);
    }

    public void setSize(int count) {
        if (count < 0) {
            count = 0;
        }
        if (count == 0) {
            this.clear();
            return;
        }
        int diff = count - this.size();
        if (diff == 0) {
            return;
        }
        this.changeSize(diff);
    }

    @Deprecated
    public void clearChildes() {
        this.clear();
    }

    public void clear() {
        T[] elementData = this.elementData;
        int length = elementData.length;
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            T block = elementData[i];
            if (block == null) continue;
            ((Block)block).setIndex(-1);
            ((Block)block).setParent(null);
            elementData[i] = null;
        }
        this.elementData = this.newArrayInstance(0);
    }

    public void addAll(T[] blocks) {
        if (blocks == null || blocks.length == 0) {
            return;
        }
        T[] old = this.elementData;
        int oldLength = 0;
        if (old != null) {
            oldLength = old.length;
        }
        int len = blocks.length;
        Block[] update = this.newArrayInstance(oldLength + len);
        if (oldLength > 0) {
            System.arraycopy(old, 0, update, 0, oldLength);
        }
        boolean foundNull = false;
        for (int i = 0; i < len; ++i) {
            T item = blocks[i];
            if (item == null) {
                foundNull = true;
                continue;
            }
            int index = oldLength + i;
            update[index] = item;
            ((Block)item).setParent(this);
            ((Block)item).setIndex(index);
        }
        this.elementData = update;
        if (foundNull) {
            this.trimNullBlocks();
        }
    }

    public boolean needsSort(Comparator<? super T> comparator) {
        T[] elementData = this.elementData;
        if (comparator == null) {
            return false;
        }
        int length = elementData.length;
        if (length < 2) {
            return false;
        }
        T previous = elementData[0];
        for (int i = 1; i < length; ++i) {
            T item = elementData[i];
            if (comparator.compare(previous, item) > 0) {
                return true;
            }
            previous = item;
        }
        return false;
    }

    public boolean sort(Comparator<? super T> comparator) {
        Object[] elementData = this.elementData;
        if (comparator == null || elementData.length < 2) {
            return false;
        }
        ArraySort.sort(elementData, comparator);
        boolean changed = false;
        for (int i = 0; i < elementData.length; ++i) {
            Object item = elementData[i];
            if (item == null || ((Block)item).getIndex() == i) continue;
            ((Block)item).setIndex(i);
            changed = true;
        }
        return changed;
    }

    public void insertItem(int index, T item) {
        int lastIndex;
        int count = this.size();
        if (count < index) {
            count = index;
        }
        this.ensureSize(count + 1);
        Block[] childes = this.getChildes();
        for (int i = lastIndex = childes.length - 2; i >= index; --i) {
            Block exist = childes[i];
            childes[i] = null;
            int newIndex = i + 1;
            childes[newIndex] = exist;
            exist.setIndex(newIndex);
        }
        childes[index] = item;
        ((Block)item).setParent(this);
        ((Block)item).setIndex(index);
    }

    public void insertItem(int index, T[] itemsArray) {
        int newIndex;
        int lastIndex;
        int i;
        int count = this.size();
        if (count < index) {
            count = index;
        }
        int itemsLength = itemsArray.length;
        this.ensureSize(count + itemsLength);
        Block[] childes = this.getChildes();
        for (i = lastIndex = childes.length - itemsLength - 1; i >= index; --i) {
            Block exist = childes[i];
            childes[i] = null;
            newIndex = i + itemsLength;
            childes[newIndex] = exist;
            if (exist == null) continue;
            exist.setIndex(newIndex);
        }
        for (i = 0; i < itemsLength; ++i) {
            T item = itemsArray[i];
            newIndex = index + i;
            childes[newIndex] = item;
            ((Block)item).setParent(this);
            ((Block)item).setIndex(newIndex);
        }
    }

    public void setItem(int index, T item) {
        this.ensureSize(index + 1);
        this.elementData[index] = item;
        if (item != null) {
            ((Block)item).setIndex(index);
            ((Block)item).setParent(this);
        }
    }

    public void addInternal(int index, T block) {
        if (this.isFlexible()) {
            this.allocateIfFull();
        } else {
            this.ensureSize(index + 1);
        }
        this.addAt(index, block);
    }

    private void addAt(int index, T block) {
        int start;
        this.onPreShifting();
        T[] elementData = this.elementData;
        for (int i = start = elementData.length - 1; i > index; --i) {
            int left = i - 1;
            T exist = elementData[left];
            elementData[left] = null;
            elementData[i] = exist;
            if (exist == null) continue;
            ((Block)exist).setIndex(i);
        }
        elementData[index] = block;
        if (block != null) {
            ((Block)block).setIndex(index);
            ((Block)block).setParent(this);
        }
        this.onPostShift(index);
        if (this.isFlexible()) {
            --this.mFreeSpace;
        }
    }

    protected void onPreShifting() {
    }

    protected void onPostShift(int index) {
    }

    public boolean add(T block) {
        if (block == null) {
            return false;
        }
        if (this.isFlexible()) {
            this.addAtNull(block);
            return true;
        }
        T[] oldElementData = this.elementData;
        int index = oldElementData.length;
        this.elementData = this.newArrayInstance(index + 1);
        if (index > 0) {
            System.arraycopy(oldElementData, 0, this.elementData, 0, index);
        }
        this.elementData[index] = block;
        ((Block)block).setIndex(index);
        ((Block)block).setParent(this);
        return true;
    }

    private void addAtNull(T block) {
        this.allocateIfFull();
        T[] elementData = this.elementData;
        int index = elementData.length - this.mFreeSpace;
        elementData[index] = block;
        ((Block)block).setIndex(index);
        ((Block)block).setParent(this);
        --this.mFreeSpace;
    }

    private int calculateAllocate() {
        ++this.mAllocateStep;
        int amount = this.size() / 4;
        if (amount < 10) {
            amount = 10;
        } else if (amount > 100) {
            amount = 100;
        }
        if ((amount *= this.mAllocateStep) > 8000) {
            amount = 8000;
        }
        return amount;
    }

    protected boolean isFlexible() {
        return false;
    }

    protected void trimAllocatedFreeSpace() {
        if (this.mFreeSpace <= 0) {
            return;
        }
        int length = this.elementData.length - this.mFreeSpace;
        Block[] update = this.newArrayInstance(length);
        if (length > 0) {
            System.arraycopy(this.elementData, 0, update, 0, length);
        }
        this.elementData = update;
        this.mFreeSpace = 0;
    }

    public final int countNonNull() {
        return this.countNonNull(true);
    }

    @Override
    public int getChildesCount() {
        return this.size();
    }

    public final int size() {
        return this.elementData.length;
    }

    public T createNext() {
        Object block = this.newInstance();
        this.add(block);
        return block;
    }

    @Override
    public final T get(int i) {
        if (i >= this.size() || i < 0) {
            return null;
        }
        return this.elementData[i];
    }

    @Override
    public int getCount() {
        return this.size();
    }

    public final T getLast() {
        return (T)this.get(this.size() - this.mFreeSpace - 1);
    }

    public int indexOf(Object block) {
        T[] items = this.elementData;
        if (items == null) {
            return -1;
        }
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            if (block != items[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object block) {
        T[] items = this.elementData;
        if (items == null) {
            return -1;
        }
        int len = items.length;
        int result = -1;
        for (int i = 0; i < len; ++i) {
            if (block != items[i]) continue;
            result = i;
        }
        return result;
    }

    public Iterator<T> arrayIterator() {
        if (this.size() == 0) {
            return EmptyIterator.of();
        }
        return new ArrayIterator(this.getChildes());
    }

    public Iterator<T> clonedIterator() {
        if (this.size() == 0) {
            return EmptyIterator.of();
        }
        return new ArrayIterator((Object[])this.getChildes().clone());
    }

    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    public Iterator<T> iterator(boolean skipNullBlock) {
        return this.iterator(skipNullBlock, 0, this.size());
    }

    public Iterator<T> iterator(int start, int size) {
        return this.iterator(false, start, size);
    }

    public Iterator<T> iterator(boolean skipNullBlock, int start, int size) {
        int count;
        this.trimAllocatedFreeSpace();
        if (start < 0) {
            start = 0;
        }
        if (size > (count = this.size() - start)) {
            size = count;
        }
        if (size == 0) {
            return EmptyIterator.of();
        }
        if (size == 1) {
            Object item = this.get(start);
            if (skipNullBlock && (item == null || ((Block)item).isNull())) {
                return EmptyIterator.of();
            }
            return SingleIterator.of(item);
        }
        return new BlockIterator(skipNullBlock, start, size);
    }

    public Iterator<T> iterator(Predicate<? super T> tester) {
        this.trimAllocatedFreeSpace();
        int count = this.size();
        if (count == 0) {
            return EmptyIterator.of();
        }
        return new PredicateIterator(tester);
    }

    public boolean contains(Object block) {
        T[] items = this.elementData;
        if (block == null || items == null) {
            return false;
        }
        int length = items.length;
        for (int i = 0; i < length; ++i) {
            if (items[i] != block) continue;
            return true;
        }
        return false;
    }

    public int remove(Predicate<? super T> predicate) {
        return this.remove(CollectionUtil.toList(this.iterator(predicate)), null);
    }

    public int remove(Collection<T> blockList) {
        return this.remove(blockList, null);
    }

    protected int remove(Collection<T> blockList, Collection<T> removedList) {
        int count = 0;
        T[] items = this.elementData;
        if (items == null || blockList == null) {
            return count;
        }
        int length = items.length;
        if (length == 0) {
            return count;
        }
        for (Block block : blockList) {
            T item;
            int index;
            if (block == null || (index = block.getIndex()) < 0 || index >= length || (item = items[index]) != block) continue;
            items[index] = null;
            this.onPreRemove(item);
            if (removedList != null) {
                removedList.add(item);
            }
            ++count;
        }
        this.trimNullBlocks();
        return count;
    }

    public void onPreRemove(T block) {
    }

    public boolean remove(T block) {
        return this.remove(block, true);
    }

    protected boolean remove(T block, boolean trim) {
        T[] items = this.elementData;
        if (block == null) {
            return false;
        }
        boolean found = false;
        for (T item : items) {
            if (block != item) continue;
            items[i] = null;
            found = true;
            this.onPreRemove(item);
        }
        if (found && trim) {
            this.trimNullBlocks();
        }
        return found;
    }

    protected void trimNullBlocks() {
        int len;
        this.mFreeSpace = 0;
        T[] items = this.elementData;
        if (items == null) {
            return;
        }
        int count = this.countNonNull(false);
        if (count == (len = items.length)) {
            return;
        }
        Block[] update = this.newArrayInstance(count);
        int index = 0;
        for (int i = 0; i < len; ++i) {
            T block = items[i];
            if (block == null) continue;
            update[index] = block;
            ((Block)block).setIndex(index);
            ++index;
        }
        this.elementData = update;
    }

    private int countNonNull(boolean is_null_check) {
        T[] items = this.elementData;
        if (items == null) {
            return 0;
        }
        int result = 0;
        for (T block : items) {
            if (block == null || is_null_check && ((Block)block).isNull()) continue;
            ++result;
        }
        return result;
    }

    private void changeSize(int amount) {
        this.mFreeSpace = 0;
        this.mAllocateStep = 0;
        T[] old = this.elementData;
        int index = 0;
        if (old != null) {
            index = old.length;
        }
        int size = index + amount;
        Block[] update = this.newArrayInstance(size);
        int end = index > size ? size : index;
        if (end > 0) {
            System.arraycopy(old, 0, update, 0, end);
        }
        for (int i = end; i < size; ++i) {
            Block item = update[i];
            if (item == null) {
                update[i] = item = this.newInstance();
            }
            item.setIndex(i);
            item.setParent(this);
        }
        this.elementData = update;
    }

    private void allocateIfFull() {
        if (this.mFreeSpace > 0) {
            return;
        }
        this.allocate(this.calculateAllocate());
    }

    private void allocate(int amount) {
        if (amount <= 0 || this.mFreeSpace > 0) {
            return;
        }
        this.mFreeSpace = amount;
        T[] old = this.elementData;
        int index = old.length;
        int size = index + amount;
        Block[] update = this.newArrayInstance(size);
        if (index == 0) {
            this.elementData = update;
            return;
        }
        System.arraycopy(old, 0, update, 0, index);
        this.elementData = update;
    }

    public String toString() {
        return "count=" + this.size();
    }

    private static boolean isAllNull(Block[] itemsList) {
        for (Block item : itemsList) {
            if (item == null || item.isNull()) continue;
            return false;
        }
        return true;
    }

    private class PredicateIterator
    implements Iterator<T> {
        private int mCursor;
        private final int mMaxSize;
        private final Predicate<? super T> mTester;

        PredicateIterator(Predicate<? super T> tester) {
            this.mTester = tester;
            this.mCursor = 0;
            this.mMaxSize = BlockArray.this.size();
        }

        @Override
        public boolean hasNext() {
            this.checkCursor();
            return this.hasItems();
        }

        @Override
        public T next() {
            if (this.hasItems()) {
                Object item = BlockArray.this.get(this.mCursor);
                ++this.mCursor;
                this.checkCursor();
                return item;
            }
            return null;
        }

        private boolean hasItems() {
            return this.mCursor < this.mMaxSize;
        }

        private void checkCursor() {
            if (this.mTester == null) {
                return;
            }
            while (this.hasItems() && !this.test(BlockArray.this.get(this.getCursor()))) {
                ++this.mCursor;
            }
        }

        private int getCursor() {
            return this.mCursor;
        }

        private boolean test(T item) {
            Predicate tester = this.mTester;
            if (tester != null) {
                return tester.test(item);
            }
            return true;
        }
    }

    private class BlockIterator
    implements Iterator<T> {
        private int mCursor;
        private final int mMaxPosition;
        private final boolean mSkipNullBlock;

        BlockIterator(boolean skipNullBlock, int start, int size) {
            this.mSkipNullBlock = skipNullBlock;
            this.mCursor = start;
            this.mMaxPosition = start + size;
        }

        @Override
        public boolean hasNext() {
            this.checkCursor();
            return !this.isFinished();
        }

        @Override
        public T next() {
            if (!this.isFinished()) {
                Object item = BlockArray.this.get(this.mCursor);
                ++this.mCursor;
                this.checkCursor();
                return item;
            }
            return null;
        }

        private boolean isFinished() {
            return this.mCursor >= this.mMaxPosition;
        }

        private void checkCursor() {
            if (!this.mSkipNullBlock || this.isFinished()) {
                return;
            }
            Object item = BlockArray.this.get(this.mCursor);
            while (item == null || ((Block)item).isNull()) {
                ++this.mCursor;
                item = BlockArray.this.get(this.mCursor);
                if (this.mCursor < this.mMaxPosition) continue;
                break;
            }
        }
    }
}

