/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class TypeBlockArray
extends BlockArray<TypeBlock>
implements JSONConvert<JSONArray>,
Comparator<TypeBlock> {
    private byte mTypeId;
    private Boolean mHasComplexEntry;
    private static final Predicate<TypeBlock> NON_EMPTY_TESTER = new Predicate<TypeBlock>(){

        @Override
        public boolean test(TypeBlock typeBlock) {
            if (typeBlock == null || typeBlock.isNull()) {
                return false;
            }
            return !typeBlock.isEmpty();
        }
    };

    public Boolean hasComplexEntry() {
        if (this.mHasComplexEntry != null) {
            return this.mHasComplexEntry;
        }
        for (TypeBlock typeBlock : this.listItems(true)) {
            Boolean hasComplex = typeBlock.getEntryArray().hasComplexEntry();
            if (hasComplex == null) continue;
            this.mHasComplexEntry = hasComplex;
        }
        return this.mHasComplexEntry;
    }

    public void destroy() {
        for (TypeBlock typeBlock : this.listItems()) {
            if (typeBlock == null) continue;
            typeBlock.destroy();
        }
        this.clear();
    }

    public void sort() {
        this.sort(this);
    }

    public boolean removeNullEntries(int startId) {
        boolean result = true;
        for (TypeBlock typeBlock : this.listItems()) {
            boolean removed = typeBlock.removeNullEntries(startId);
            result = result && removed;
        }
        return result;
    }

    public void removeEmptyBlocks() {
        TypeBlock[] typeBlocks = (TypeBlock[])((TypeBlock[])this.getChildes()).clone();
        boolean foundEmpty = false;
        for (TypeBlock typeBlock : typeBlocks) {
            if (!typeBlock.isEmpty()) continue;
            super.remove(typeBlock, false);
            foundEmpty = true;
        }
        if (foundEmpty) {
            this.trimNullBlocks();
        }
    }

    public Entry getOrCreateEntry(short entryId, String qualifiers) {
        TypeBlock typeBlock = this.getOrCreate(qualifiers);
        return typeBlock.getOrCreateEntry(entryId);
    }

    public Entry getOrCreateEntry(short entryId, ResConfig resConfig) {
        TypeBlock typeBlock = this.getOrCreate(resConfig);
        return typeBlock.getOrCreateEntry(entryId);
    }

    public boolean isEmpty() {
        for (TypeBlock typeBlock : this.listItems()) {
            if (typeBlock == null || typeBlock.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Entry getEntry(short entryId, String qualifiers) {
        TypeBlock typeBlock = this.getTypeBlock(qualifiers);
        if (typeBlock == null) {
            return null;
        }
        return typeBlock.getEntry(entryId);
    }

    public Entry getEntry(ResConfig resConfig, String entryName) {
        TypeBlock typeBlock = this.getTypeBlock(resConfig);
        if (typeBlock != null) {
            return typeBlock.getEntry(entryName);
        }
        return null;
    }

    public TypeBlock getOrCreate(ResConfig resConfig) {
        return this.getOrCreate(resConfig, false);
    }

    public TypeBlock getOrCreate(ResConfig resConfig, boolean sparse) {
        return this.getOrCreate(resConfig, sparse, false);
    }

    public TypeBlock getOrCreate(ResConfig resConfig, boolean sparse, boolean offset16) {
        TypeBlock typeBlock = this.getTypeBlock(resConfig, sparse);
        if (typeBlock != null) {
            return typeBlock;
        }
        byte id = this.getTypeId();
        typeBlock = this.createNext(sparse, offset16);
        typeBlock.setTypeId(id);
        ResConfig config = typeBlock.getResConfig();
        config.copyFrom(resConfig);
        return typeBlock;
    }

    public TypeBlock getOrCreate(String qualifiers) {
        TypeBlock typeBlock = this.getTypeBlock(qualifiers);
        if (typeBlock != null) {
            return typeBlock;
        }
        int count = this.getHighestEntryCount();
        typeBlock = (TypeBlock)this.createNext();
        typeBlock.ensureEntriesCount(count);
        ResConfig config = typeBlock.getResConfig();
        config.parseQualifiers(qualifiers);
        return typeBlock;
    }

    public TypeBlock getTypeBlock(String qualifiers) {
        TypeBlock[] items = (TypeBlock[])this.getChildes();
        if (items == null) {
            return null;
        }
        for (TypeBlock block : items) {
            if (!block.getResConfig().isEqualQualifiers(qualifiers)) continue;
            return block;
        }
        return null;
    }

    public TypeBlock getTypeBlock(ResConfig config) {
        if (config == null) {
            return null;
        }
        TypeBlock[] items = (TypeBlock[])this.getChildes();
        if (items == null) {
            return null;
        }
        for (TypeBlock typeBlock : items) {
            if (typeBlock == null || !config.equals(typeBlock.getResConfig())) continue;
            return typeBlock;
        }
        return null;
    }

    public TypeBlock getTypeBlock(ResConfig config, boolean sparse) {
        if (config == null) {
            return null;
        }
        TypeBlock[] items = (TypeBlock[])this.getChildes();
        if (items == null) {
            return null;
        }
        for (TypeBlock typeBlock : items) {
            if (typeBlock == null || sparse != typeBlock.isSparse() || !config.equals(typeBlock.getResConfig())) continue;
            return typeBlock;
        }
        return null;
    }

    public void setTypeId(byte id) {
        this.mTypeId = id;
        TypeBlock[] allChildes = (TypeBlock[])this.getChildes();
        if (allChildes == null) {
            return;
        }
        for (TypeBlock typeBlock : allChildes) {
            typeBlock.setTypeId(id);
        }
    }

    public byte getTypeId() {
        byte id;
        SpecBlock specBlock = this.getSpecBlock();
        if (specBlock != null && (id = specBlock.getTypeId()) != 0) {
            return id;
        }
        if (this.mTypeId != 0) {
            return this.mTypeId;
        }
        TypeBlock[] childes = (TypeBlock[])this.getChildes();
        if (childes == null) {
            return 0;
        }
        for (TypeBlock typeBlock : childes) {
            byte id2;
            if (typeBlock == null || (id2 = typeBlock.getTypeId()) == 0) continue;
            if (specBlock != null) {
                specBlock.setTypeId(id2);
            }
            this.mTypeId = id2;
            return id2;
        }
        return 0;
    }

    public Set<ResConfig> listResConfig() {
        HashSet<ResConfig> unique = new HashSet<ResConfig>();
        for (TypeBlock typeBlock : (TypeBlock[])this.getChildes()) {
            unique.add(typeBlock.getResConfig());
        }
        return unique;
    }

    public Iterator<ResConfig> getResConfigs() {
        return new ComputeIterator<TypeBlock, ResConfig>(super.iterator(true), TypeBlock::getResConfig);
    }

    public Iterator<TypeBlock> iteratorNonEmpty() {
        return super.iterator(NON_EMPTY_TESTER);
    }

    public Iterator<TypeBlock> iterator(final ResConfig resConfig) {
        return this.iterator(new Predicate<TypeBlock>(){

            @Override
            public boolean test(TypeBlock typeBlock) {
                return typeBlock.getResConfig().equals(resConfig);
            }
        });
    }

    public boolean hasDuplicateResConfig(boolean ignoreEmpty) {
        HashSet<Integer> uniqueHashSet = new HashSet<Integer>();
        Iterator<TypeBlock> itr = ignoreEmpty ? this.iteratorNonEmpty() : this.iterator(true);
        while (itr.hasNext()) {
            Integer hash = itr.next().getResConfig().hashCode();
            if (uniqueHashSet.contains(hash)) {
                return true;
            }
            uniqueHashSet.add(hash);
        }
        return false;
    }

    private SpecBlock getSpecBlock() {
        SpecTypePair parent = this.getParent(SpecTypePair.class);
        if (parent != null) {
            return parent.getSpecBlock();
        }
        return null;
    }

    @Override
    protected boolean remove(TypeBlock block, boolean trim) {
        if (block == null) {
            return false;
        }
        block.cleanEntries();
        return super.remove(block, trim);
    }

    @Override
    public TypeBlock newInstance() {
        byte id = this.getTypeId();
        TypeBlock typeBlock = new TypeBlock(false, false);
        typeBlock.setTypeId(id);
        return typeBlock;
    }

    public TypeBlock[] newArrayInstance(int len) {
        return new TypeBlock[len];
    }

    public TypeBlock createNext(boolean sparse, boolean offset16) {
        byte id = this.getTypeId();
        TypeBlock typeBlock = new TypeBlock(sparse, offset16);
        typeBlock.setTypeId(id);
        this.add(typeBlock);
        return typeBlock;
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean readOk = true;
        while (readOk) {
            readOk = this.readTypeBlockArray(reader);
        }
    }

    private boolean readTypeBlockArray(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType != ChunkType.TYPE) {
            return false;
        }
        TypeHeader typeHeader = TypeHeader.read(reader);
        byte id = this.getTypeId();
        if (id != 0 && typeHeader.getId().unsignedInt() != id) {
            return false;
        }
        int pos = reader.getPosition();
        TypeBlock typeBlock = (TypeBlock)this.createNext();
        typeBlock.readBytes(reader);
        return reader.getPosition() > pos;
    }

    public int getHighestEntryId() {
        int result = -1;
        for (TypeBlock typeBlock : (TypeBlock[])this.getChildes()) {
            int high = typeBlock.getEntryArray().getHighestEntryId();
            if (high <= result) continue;
            result = high;
        }
        return result;
    }

    public int getHighestEntryCount() {
        int result = 0;
        for (TypeBlock typeBlock : (TypeBlock[])this.getChildes()) {
            int count = typeBlock.getEntryArray().size();
            if (count <= result) continue;
            result = count;
        }
        return result;
    }

    public void setEntryCount(int count) {
        for (TypeBlock typeBlock : (TypeBlock[])this.getChildes()) {
            if (typeBlock.isSparse()) continue;
            typeBlock.setEntryCount(count);
        }
    }

    public TypeString getTypeString() {
        for (TypeBlock typeBlock : (TypeBlock[])this.getChildes()) {
            TypeString typeString = typeBlock.getTypeString();
            if (typeString == null) continue;
            return typeString;
        }
        return null;
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (TypeBlock typeBlock : this.listItems()) {
            JSONObject jsonObject = typeBlock.toJson();
            if (jsonObject == null) continue;
            jsonArray.put(i, jsonObject);
            ++i;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json == null) {
            return;
        }
        int length = json.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            TypeBlock typeBlock = this.createNext(jsonObject.optBoolean("is_sparse", false), jsonObject.optBoolean("is_offset16", false));
            typeBlock.fromJson(jsonObject);
        }
    }

    public void merge(TypeBlockArray typeBlockArray) {
        if (typeBlockArray == null || typeBlockArray == this) {
            return;
        }
        for (TypeBlock typeBlock : typeBlockArray.listItems()) {
            TypeBlock exist = this.getOrCreate(typeBlock.getResConfig(), typeBlock.isSparse());
            exist.merge(typeBlock);
        }
    }

    @Deprecated
    public Entry searchByEntryName(String entryName) {
        if (entryName == null) {
            return null;
        }
        TypeBlock[] childes = (TypeBlock[])this.getChildes();
        if (childes == null || childes.length == 0) {
            return null;
        }
        return childes[0].getEntry(entryName);
    }

    @Override
    public int compare(TypeBlock typeBlock1, TypeBlock typeBlock2) {
        return typeBlock1.compareTo(typeBlock2);
    }
}

