/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.OffsetBlockArray;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import java.io.IOException;

public class StyleArray
extends OffsetBlockArray<StyleItem>
implements Iterable<StyleItem>,
JSONConvert<JSONArray> {
    private static final byte END_BYTE = -1;

    public StyleArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart) {
        super(offsets, itemCount, itemStart);
    }

    protected void onStringShifted(int index) {
        StyleItem styleItem = (StyleItem)this.get(index);
        if (styleItem == null || styleItem.getIndex() == index) {
            return;
        }
        styleItem = this.newInstance();
        this.setItem(index, styleItem);
        styleItem.setNull(true);
        styleItem.linkStringsInternal();
    }

    @Override
    public void clear() {
        for (StyleItem styleItem : this.listItems(true)) {
            styleItem.onRemoved();
        }
        super.clear();
    }

    @Override
    void refreshAlignment(BlockReader reader, AlignItem alignItem) throws IOException {
        alignItem.clear();
        alignItem.setFill((byte)-1);
        if (reader.available() < 4) {
            return;
        }
        IntegerItem integerItem = new IntegerItem();
        while (reader.available() >= 4) {
            int position = reader.getPosition();
            integerItem.readBytes(reader);
            if (integerItem.get() != -1) {
                reader.seek(position);
                break;
            }
            alignItem.setSize(alignItem.size() + 4);
        }
    }

    @Override
    void refreshAlignment(AlignItem alignItem) {
        if (this.size() == 0) {
            alignItem.clear();
            return;
        }
        alignItem.setFill((byte)-1);
        alignItem.ensureSize(8);
    }

    @Override
    protected void refreshChildes() {
    }

    @Override
    protected boolean remove(StyleItem block, boolean trim) {
        if (block == null) {
            return false;
        }
        boolean removed = super.remove(block, trim);
        if (!removed && trim) {
            this.trimNullBlocks();
        }
        return removed;
    }

    @Override
    public StyleItem newInstance() {
        return new StyleItem();
    }

    public StyleItem[] newArrayInstance(int len) {
        return new StyleItem[len];
    }

    @Override
    public JSONArray toJson() {
        return null;
    }

    @Override
    public void fromJson(JSONArray json) {
    }

    public void merge(StyleArray styleArray) {
        if (styleArray == null || styleArray == this) {
            return;
        }
        if (!this.isEmpty()) {
            return;
        }
        int count = styleArray.size();
        this.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            StyleItem exist = (StyleItem)this.get(i);
            StyleItem coming = (StyleItem)styleArray.get(i);
            exist.merge(coming);
        }
    }
}

