/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ResXmlString;
import java.util.ArrayList;
import java.util.List;

public class ResXmlStringArray
extends StringArray<ResXmlString> {
    private static final ResXmlString[] EMPTY = new ResXmlString[0];

    public ResXmlStringArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        super(offsets, itemCount, itemStart, is_utf8);
    }

    @Override
    List<ResXmlString> listUnusedStringsToRemove() {
        ArrayList<ResXmlString> results = new ArrayList<ResXmlString>();
        ResXmlIDMap idMap = this.getResXmlIDMap();
        int lastIndex = -1;
        if (idMap != null) {
            lastIndex = idMap.countId();
        }
        for (ResXmlString item : this.listItems()) {
            if (item == null || item.hasReference() || item.getIndex() < lastIndex) continue;
            results.add(item);
        }
        return results;
    }

    private ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument xmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (xmlDocument != null) {
            return xmlDocument.getResXmlIDMap();
        }
        return null;
    }

    @Override
    public ResXmlString newInstance() {
        return new ResXmlString(this.isUtf8());
    }

    public ResXmlString[] newArrayInstance(int length) {
        if (length == 0) {
            return EMPTY;
        }
        return new ResXmlString[length];
    }
}

