/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.Archive;
import com.reandroid.archive.block.DataDescriptor;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.block.ZipHeader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZipAligner {
    private final Map<Pattern, Integer> alignmentMap = new HashMap<Pattern, Integer>();
    private int defaultAlignment;
    private boolean enableDataDescriptor;
    private static final int ALIGNMENT_4 = 4;
    private static final int ALIGNMENT_PAGE = 4096;

    public void setFileAlignment(Pattern patternFileName, int alignment) {
        if (patternFileName == null) {
            return;
        }
        this.alignmentMap.remove(patternFileName);
        if (alignment > 1) {
            this.alignmentMap.put(patternFileName, alignment);
        }
    }

    public void clearFileAlignment() {
        this.alignmentMap.clear();
    }

    public void setDefaultAlignment(int defaultAlignment) {
        if (defaultAlignment <= 0) {
            defaultAlignment = 1;
        }
        this.defaultAlignment = defaultAlignment;
    }

    public void setEnableDataDescriptor(boolean enableDataDescriptor) {
        this.enableDataDescriptor = enableDataDescriptor;
    }

    public void align(long offset, LocalFileHeader lfh) {
        int padding;
        if (ZipHeader.isZip64Length(offset + lfh.getSize())) {
            return;
        }
        lfh.setZipAlign(0);
        if (lfh.getMethod() != Archive.STORED) {
            padding = 0;
            this.createDataDescriptor(lfh);
        } else {
            int alignment = this.getAlignment(lfh.getFileName());
            long dataOffset = offset + (long)lfh.countBytes();
            padding = (int)(((long)alignment - dataOffset % (long)alignment) % (long)alignment);
        }
        lfh.setZipAlign(padding);
    }

    private void createDataDescriptor(LocalFileHeader lfh) {
        DataDescriptor dataDescriptor = this.enableDataDescriptor ? DataDescriptor.fromLocalFile(lfh) : null;
        lfh.setDataDescriptor(dataDescriptor);
    }

    private int getAlignment(String name) {
        for (Map.Entry<Pattern, Integer> entry : this.alignmentMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(name);
            if (!matcher.matches()) continue;
            return entry.getValue();
        }
        return this.defaultAlignment;
    }

    public static ZipAligner apkAligner() {
        ZipAligner zipAligner = new ZipAligner();
        zipAligner.setDefaultAlignment(4);
        Pattern patternNativeLib = Pattern.compile("^lib/.+\\.so$");
        zipAligner.setFileAlignment(patternNativeLib, 4096);
        zipAligner.setEnableDataDescriptor(true);
        return zipAligner;
    }
}

