/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.ArchiveInfo;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.DataDescriptor;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.writer.HeaderInterceptor;

public class HeaderInterceptorChain
implements HeaderInterceptor {
    private ArchiveInfo archiveInfo;
    private HeaderInterceptor headerInterceptor;

    private HeaderInterceptorChain() {
    }

    public ArchiveInfo getArchiveInfo() {
        return this.archiveInfo;
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public boolean isDisabled() {
        return this.getArchiveInfo() == null && this.getHeaderInterceptor() == null;
    }

    public void setHeaderInterceptor(HeaderInterceptor headerInterceptor) {
        this.headerInterceptor = headerInterceptor;
    }

    public HeaderInterceptor getHeaderInterceptor() {
        return this.headerInterceptor;
    }

    @Override
    public void onWriteLfh(LocalFileHeader header) {
        HeaderInterceptor interceptor = this.getArchiveInfo();
        if (interceptor != null) {
            interceptor.onWriteLfh(header);
        }
        if ((interceptor = this.getHeaderInterceptor()) != null) {
            interceptor.onWriteLfh(header);
        }
    }

    @Override
    public void onWriteDD(DataDescriptor dataDescriptor) {
        HeaderInterceptor interceptor = this.getArchiveInfo();
        if (interceptor != null) {
            interceptor.onWriteDD(dataDescriptor);
        }
        if ((interceptor = this.getHeaderInterceptor()) != null) {
            interceptor.onWriteDD(dataDescriptor);
        }
    }

    @Override
    public void onWriteCeh(CentralEntryHeader header) {
        HeaderInterceptor interceptor = this.getArchiveInfo();
        if (interceptor != null) {
            interceptor.onWriteCeh(header);
        }
        if ((interceptor = this.getHeaderInterceptor()) != null) {
            interceptor.onWriteCeh(header);
        }
    }

    public static HeaderInterceptorChain createDefault() {
        HeaderInterceptorChain interceptorChain = new HeaderInterceptorChain();
        interceptorChain.setArchiveInfo(ArchiveInfo.apk());
        return interceptorChain;
    }
}

