/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class CountingOutputStream<T extends OutputStream>
extends OutputStream {
    private final T outputStream;
    private CRC32 crc;
    private long size;
    private boolean mClosed;

    public CountingOutputStream(T outputStream, boolean disableCrc) {
        this.outputStream = outputStream;
        CRC32 crc32 = disableCrc ? null : new CRC32();
        this.crc = crc32;
    }

    public CountingOutputStream(T outputStream) {
        this(outputStream, false);
    }

    public void disableCrc(boolean disableCrc) {
        if (!disableCrc) {
            if (this.crc == null) {
                this.crc = new CRC32();
            }
        } else {
            this.crc = null;
        }
    }

    public void reset() {
        this.crc = new CRC32();
        this.size = 0L;
    }

    public T getOutputStream() {
        return this.outputStream;
    }

    public long getSize() {
        return this.size;
    }

    public long getCrc() {
        if (this.crc != null) {
            return this.crc.getValue();
        }
        return 0L;
    }

    public void write(InputStream inputStream) throws IOException {
        int length;
        int bufferStep = 500;
        int maxBuffer = 81920;
        byte[] buffer = new byte[2048];
        while ((length = inputStream.read(buffer, 0, buffer.length)) >= 0) {
            this.write(buffer, 0, length);
            if (buffer.length >= maxBuffer) continue;
            buffer = new byte[buffer.length + bufferStep];
        }
        inputStream.close();
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        ((OutputStream)this.outputStream).write(bytes, offset, length);
        this.size += (long)length;
        if (this.crc != null) {
            this.crc.update(bytes, offset, length);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i}, 0, 1);
    }

    @Override
    public void close() throws IOException {
        ((OutputStream)this.outputStream).close();
        this.mClosed = true;
    }

    public boolean isOpen() {
        return !this.mClosed;
    }

    @Override
    public void flush() throws IOException {
        ((OutputStream)this.outputStream).flush();
    }

    public String toString() {
        return "[" + this.size + "]: " + this.outputStream.getClass().getSimpleName();
    }
}

