/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.ZipHeader;

public class Zip64Record
extends ZipHeader {
    public static final int MIN_LENGTH = 56;
    public static final int MAX_LENGTH = 56;
    private static final int OFFSET_sizeOfEOCDR = 4;
    private static final int OFFSET_versionCreator = 12;
    private static final int OFFSET_versionViewer = 14;
    private static final int OFFSET_diskNumber = 16;
    private static final int OFFSET_diskCD = 20;
    private static final int OFFSET_numberOfCDRecords = 24;
    private static final int OFFSET_totalCDRecords = 32;
    private static final int OFFSET_sizeOfCD = 40;
    private static final int OFFSET_offsetOfCentralDirectory = 48;

    public Zip64Record() {
        super(56, ZipSignature.ZIP64_RECORD);
    }

    public long getSizeOfEOCDR() {
        return this.getLong(4);
    }

    public void setSizeOfEOCDR(long value) {
        this.putLong(4, value);
    }

    public int getVersionCreator() {
        return this.getShortUnsigned(12);
    }

    public void setVersionCreator(int value) {
        this.putShort(12, value);
    }

    public int getVersionViewer() {
        return this.getShortUnsigned(12);
    }

    public void setVersionViewer(int value) {
        this.putShort(14, value);
    }

    public int getDiskNumber() {
        return this.getInteger(16);
    }

    public void setDiskNumber(int value) {
        this.putInteger(16, value);
    }

    public int getDiskCD() {
        return this.getInteger(20);
    }

    public void setDiskCD(int value) {
        this.putInteger(20, value);
    }

    public long getNumberOfCDRecords() {
        return this.getLong(24);
    }

    public void setNumberOfCDRecords(long value) {
        this.putLong(24, value);
    }

    public long getTotalCDRecords() {
        return this.getLong(32);
    }

    public void setTotalCDRecords(long value) {
        this.putLong(32, value);
    }

    public long getSizeOfCD() {
        return this.getLong(40);
    }

    public void setSizeOfCD(long value) {
        this.putLong(40, value);
    }

    public long getOffsetOfCentralDirectory() {
        return this.getLong(48);
    }

    public void setOffsetOfCentralDirectory(long value) {
        this.putLong(48, value);
    }

    public String toString() {
        if (this.countBytes() < this.getMinByteLength()) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getSignature());
        builder.append(", EOCDR=").append(this.getSizeOfEOCDR());
        builder.append(", creator=").append(this.getVersionCreator());
        builder.append(", viewer=").append(this.getVersionViewer());
        builder.append(", disk number=").append(this.getDiskNumber());
        builder.append(", disk CD=").append(this.getDiskCD());
        builder.append(", noOf CDR=").append(this.getNumberOfCDRecords());
        builder.append(", total rec=").append(this.getTotalCDRecords());
        builder.append(", size of CD=").append(this.getSizeOfCD());
        builder.append(", offset of CD=").append(this.getOffsetOfCentralDirectory());
        return builder.toString();
    }

    public static Zip64Record newZip64Record() {
        Zip64Record zip64Record = new Zip64Record();
        zip64Record.setSignature(ZipSignature.ZIP64_RECORD);
        zip64Record.setSizeOfEOCDR(44L);
        zip64Record.setVersionCreator(45);
        zip64Record.setVersionViewer(45);
        return zip64Record;
    }
}

