/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.ZipHeader;

public class Zip64Locator
extends ZipHeader {
    private static final int OFFSET_offsetZip64Record = 8;
    private static final int OFFSET_numberOfDisks = 16;
    public static final int MIN_LENGTH = 20;

    public Zip64Locator() {
        super(20, ZipSignature.ZIP64_LOCATOR);
    }

    public long getOffsetZip64Record() {
        return this.getLong(8);
    }

    public void setOffsetZip64Record(long value) {
        this.putLong(8, value);
    }

    public int getNumberOfDisks() {
        return this.getInteger(16);
    }

    public void setNumberOfDisks(int value) {
        this.putInteger(16, value);
    }

    public String toString() {
        if (this.countBytes() < this.getMinByteLength()) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getSignature());
        builder.append(", offsetZip64Record=").append(this.getOffsetZip64Record());
        builder.append(", numberOfDisks=").append(this.getNumberOfDisks());
        return builder.toString();
    }

    public static Zip64Locator newZip64Locator() {
        Zip64Locator zip64Locator = new Zip64Locator();
        zip64Locator.setSignature(ZipSignature.ZIP64_LOCATOR);
        zip64Locator.setNumberOfDisks(1);
        return zip64Locator;
    }
}

