/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.CommonHeader;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class CentralEntryHeader
extends CommonHeader {
    private String mComment;
    private static final int OFFSET_signature = 0;
    private static final int OFFSET_versionMadeBy = 4;
    private static final int OFFSET_versionExtract = 6;
    private static final int OFFSET_general_purpose = 8;
    private static final int OFFSET_method = 10;
    private static final int OFFSET_dos_time = 12;
    private static final int OFFSET_dos_date = 14;
    private static final int OFFSET_crc = 16;
    private static final int OFFSET_compressed_size = 20;
    private static final int OFFSET_size = 24;
    private static final int OFFSET_fileNameLength = 28;
    private static final int OFFSET_extraLength = 30;
    private static final int OFFSET_commentLength = 32;
    private static final int OFFSET_diskStart = 34;
    private static final int OFFSET_internalFileAttributes = 36;
    private static final int OFFSET_externalFileAttributes = 38;
    private static final int OFFSET_localRelativeOffset = 42;
    private static final int OFFSET_fileName = 46;

    public CentralEntryHeader() {
        super(46, ZipSignature.CENTRAL_FILE, 8);
    }

    public CentralEntryHeader(String name) {
        this();
        this.setFileName(name);
    }

    @Override
    boolean isZip64Value() {
        return CentralEntryHeader.isZip64Value(this.getInteger(42));
    }

    @Override
    int getZip64BytesLength() {
        return 12;
    }

    private int getOffsetZip64LocalRelativeOffset() {
        return this.getOffsetZip64FieldLength() + 2;
    }

    @Override
    int readComment(InputStream inputStream) throws IOException {
        int commentLength = this.getCommentLength();
        if (commentLength == 0) {
            this.mComment = "";
            return 0;
        }
        this.setCommentLength(commentLength);
        byte[] bytes = this.getBytesInternal();
        int read = inputStream.read(bytes, this.getOffsetComment(), commentLength);
        if (read != commentLength) {
            throw new IOException("Stream ended before reading comment: read=" + read + ", name length=" + commentLength);
        }
        this.mComment = null;
        return commentLength;
    }

    public int getVersionExtract() {
        return this.getShortUnsigned(6);
    }

    @Override
    public void setVersionExtract(int value) {
        this.putShort(6, value);
    }

    public String getComment() {
        if (this.mComment == null) {
            this.mComment = this.decodeComment();
        }
        return this.mComment;
    }

    public void setComment(String comment) {
        if (comment == null) {
            comment = "";
        }
        byte[] strBytes = comment.getBytes(StandardCharsets.UTF_8);
        int length = strBytes.length;
        this.setCommentLength(length);
        if (length == 0) {
            this.mComment = comment;
            return;
        }
        byte[] bytes = this.getBytesInternal();
        System.arraycopy(strBytes, 0, bytes, this.getOffsetComment(), length);
        this.mComment = comment;
    }

    @Override
    public int getCommentLength() {
        return this.getShortUnsigned(32);
    }

    public void setCommentLength(int value) {
        int length = this.getOffsetComment() + value;
        this.setBytesLength(length, false);
        this.putShort(32, value);
    }

    public long getLocalRelativeOffset() {
        if (this.isZip64()) {
            return this.getLong(this.getOffsetZip64LocalRelativeOffset());
        }
        return this.getIntegerUnsigned(42);
    }

    public void setLocalRelativeOffset(long offset) {
        if (this.isZip64Value() || CentralEntryHeader.isZip64Value(offset)) {
            this.ensureZip64();
            this.putInteger(42, -1);
            this.putLong(this.getOffsetZip64LocalRelativeOffset(), offset);
        } else {
            this.putInteger(42, offset);
        }
    }

    public int getInternalFileAttributes() {
        return this.getShortUnsigned(36);
    }

    public void setInternalFileAttributes(int value) {
        this.putShort(36, value);
    }

    public int getExternalFileAttributes() {
        return this.getShortUnsigned(38);
    }

    public void setExternalFileAttributes(int value) {
        this.putShort(38, value);
    }

    @Override
    void onUtf8Changed(boolean oldValue) {
        String str = this.mComment;
        if (str != null) {
            this.setComment(str);
        }
    }

    public boolean matches(LocalFileHeader localFileHeader) {
        if (localFileHeader == null) {
            return false;
        }
        return this.getCrc() == localFileHeader.getCrc() && Objects.equals(this.getFileName(), localFileHeader.getFileName());
    }

    @Override
    public String toString() {
        if (this.countBytes() < this.getMinByteLength()) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[').append(this.getFileOffset()).append(']');
        String str = this.getFileName();
        boolean appendOnce = false;
        if (str.length() > 0) {
            builder.append("name=").append(str);
            appendOnce = true;
        }
        if ((str = this.getComment()).length() > 0) {
            if (appendOnce) {
                builder.append(", ");
            }
            builder.append("comment=").append(str);
            appendOnce = true;
        }
        if (appendOnce) {
            builder.append(", ");
        }
        builder.append("SIG=").append((Object)this.getSignature());
        builder.append(", versionMadeBy=").append(HexUtil.toHex4((short)this.getVersionMadeBy()));
        builder.append(", versionExtract=").append(HexUtil.toHex4((short)this.getVersionExtract()));
        builder.append(", GP={").append(this.getGeneralPurposeFlag()).append("}");
        builder.append(", method=").append(this.getMethod());
        builder.append(", date=").append(HexUtil.toHex(this.getDosTime(), 1));
        builder.append(", crc=").append(HexUtil.toHex8(this.getCrc()));
        builder.append(", cSize=").append(this.getCompressedSize());
        builder.append(", size=").append(this.getSize());
        builder.append(", fileNameLength=").append(this.getFileNameLength());
        builder.append(", extraLength=").append(this.getExtraLength());
        builder.append(", commentLength=").append(this.getCommentLength());
        builder.append(", offset=").append(this.getLocalRelativeOffset());
        builder.append(", internalFileAttributes=").append(this.getInternalFileAttributes());
        builder.append(", externalFileAttributes=").append(this.getExternalFileAttributes());
        return builder.toString();
    }

    public static CentralEntryHeader fromLocalFileHeader(LocalFileHeader lfh) {
        CentralEntryHeader ceh = new CentralEntryHeader();
        ceh.setSignature(ZipSignature.CENTRAL_FILE);
        ceh.setVersionMadeBy(768);
        long offset = lfh.getFileOffset() - (long)lfh.countBytes();
        ceh.setLocalRelativeOffset(offset);
        ceh.getGeneralPurposeFlag().setValue(lfh.getGeneralPurposeFlag().getValue());
        ceh.setMethod(lfh.getMethod());
        ceh.setDosTime(lfh.getDosTime());
        ceh.setCrc(lfh.getCrc());
        ceh.setCompressedSize(lfh.getCompressedSize());
        ceh.setSize(lfh.getSize());
        ceh.setFileName(lfh.getFileName());
        return ceh;
    }
}

