/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.writer.ApkFileWriter;
import com.reandroid.archive.writer.ZipAligner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ZipAlign {
    public static void alignApk(File apkFile) throws IOException {
        if (!apkFile.isFile()) {
            throw new FileNotFoundException("No such file: " + apkFile);
        }
        File tmp = ZipAlign.toTmpFile(apkFile);
        try {
            ZipAlign.alignApk(apkFile, tmp);
        }
        catch (IOException ex) {
            tmp.delete();
            throw ex;
        }
        apkFile.delete();
        tmp.renameTo(apkFile);
    }

    public static void alignApk(File apkFile, File outFile) throws IOException {
        ZipAlign.align(apkFile, outFile, ZipAligner.apkAligner());
    }

    public static void align(File zipFile, File outFile, int alignment) throws IOException {
        ZipAligner zipAligner = new ZipAligner();
        zipAligner.setDefaultAlignment(alignment);
        ZipAlign.align(zipFile, outFile, zipAligner);
    }

    public static void align(File zipFile, File outFile, ZipAligner zipAligner) throws IOException {
        if (zipFile.equals(outFile)) {
            throw new IOException("Input and output are equal: " + zipFile);
        }
        ArchiveFile archiveFile = new ArchiveFile(zipFile);
        ApkFileWriter writer = new ApkFileWriter(outFile, archiveFile.getInputSources());
        writer.setZipAligner(zipAligner);
        writer.write();
    }

    private static File toTmpFile(File file) {
        String name = file.getName() + ".align.tmp";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }
}

