/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.apk.CrcOutputStream;
import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockRefresh;
import java.io.IOException;
import java.io.OutputStream;

public class BlockInputSource<T extends Block>
extends ByteInputSource {
    private final T mBlock;

    public BlockInputSource(String name, T block) {
        super(new byte[0], name);
        this.mBlock = block;
    }

    public BlockInputSource(InputSource inputSource, T block) {
        this(inputSource.getAlias(), block);
        this.setMethod(inputSource.getMethod());
        this.setSort(inputSource.getSort());
    }

    public T getBlock() {
        T block = this.mBlock;
        if (block instanceof BlockRefresh) {
            ((BlockRefresh)block).refresh();
        }
        return block;
    }

    @Override
    public long getLength() throws IOException {
        T block = this.getBlock();
        return ((Block)block).countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        T block = this.getBlock();
        CrcOutputStream outputStream = new CrcOutputStream();
        ((Block)block).writeBytes(outputStream);
        return outputStream.getCrcValue();
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return ((Block)this.getBlock()).writeBytes(outputStream);
    }

    @Override
    public byte[] getBytes() {
        return ((Block)this.getBlock()).getBytes();
    }
}

