/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.utils.StringsUtil;

public class ArchiveUtil {
    public static String sanitizePath(String path) {
        if (StringsUtil.isEmpty(path)) {
            return null;
        }
        path = path.replace('\\', '/');
        char[] chars = path.toCharArray();
        int length = chars.length;
        StringBuilder builder = new StringBuilder(length);
        StringBuilder dots = null;
        boolean skip = false;
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = chars[i];
            if (skip) {
                builder.append(ch);
                continue;
            }
            if (ch == '.') {
                if (dots == null) {
                    dots = new StringBuilder(5);
                }
                dots.append(ch);
                continue;
            }
            if (ch == '/') {
                dots = null;
                if (i != last) continue;
                builder.append(ch);
                continue;
            }
            builder = new StringBuilder(length);
            if (dots != null) {
                builder.append(dots.toString());
                dots = null;
            }
            builder.append(ch);
            skip = true;
        }
        if (dots == null) {
            return builder.toString();
        }
        String tmp = dots.toString();
        if (tmp.length() > 2) {
            return tmp;
        }
        return null;
    }
}

