/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.app;

public class AndroidApiLevel
implements Comparable<AndroidApiLevel> {
    public static final AndroidApiLevel B = new AndroidApiLevel("B", 1, "1.0", "Android 1.0");
    public static final AndroidApiLevel B_1_1 = new AndroidApiLevel("B_1_1", 2, "1.1", "Petit Four");
    public static final AndroidApiLevel C = new AndroidApiLevel("C", 3, "1.5", "Cupcake");
    public static final AndroidApiLevel D = new AndroidApiLevel("D", 4, "1.6", "Donut");
    public static final AndroidApiLevel E = new AndroidApiLevel("E", 5, "2.0", "Eclair");
    public static final AndroidApiLevel E_0_1 = new AndroidApiLevel("E_0_1", 6, "2.0.1", "Eclair");
    public static final AndroidApiLevel E_MR1 = new AndroidApiLevel("E_MR1", 7, "2.1", "Eclair");
    public static final AndroidApiLevel F = new AndroidApiLevel("F", 8, "2.2", "2.2.3", "Froyo");
    public static final AndroidApiLevel G = new AndroidApiLevel("G", 9, "2.3", "2.3.2", "Gingerbread");
    public static final AndroidApiLevel G_MR1 = new AndroidApiLevel("G_MR1", 10, "2.3.3", "2.3.7", "Gingerbread");
    public static final AndroidApiLevel H = new AndroidApiLevel("H", 11, "3.0", "Honeycomb");
    public static final AndroidApiLevel H_MR1 = new AndroidApiLevel("H_MR1", 12, "3.1", "Honeycomb");
    public static final AndroidApiLevel H_MR2 = new AndroidApiLevel("H_MR2", 13, "3.2", "3.2.6", "Honeycomb");
    public static final AndroidApiLevel I = new AndroidApiLevel("I", 14, "4.0", "4.0.2", "Ice Cream Sandwich");
    public static final AndroidApiLevel I_MR1 = new AndroidApiLevel("I_MR1", 15, "4.0.3", "4.0.4", "Ice Cream Sandwich");
    public static final AndroidApiLevel J = new AndroidApiLevel("J", 16, "4.1", "4.1.2", "Jelly Bean");
    public static final AndroidApiLevel J_MR1 = new AndroidApiLevel("J_MR1", 17, "4.2", "4.2.2", "Jelly Bean");
    public static final AndroidApiLevel J_MR2 = new AndroidApiLevel("J_MR2", 18, "4.3", "4.3.1", "Jelly Bean");
    public static final AndroidApiLevel K = new AndroidApiLevel("K", 19, "4.4", "4.4.4", "Key Lime Pie");
    public static final AndroidApiLevel K_WATCH = new AndroidApiLevel("K_WATCH", 20, "4.4", "4.4.2", "Key Lime Pie");
    public static final AndroidApiLevel L = new AndroidApiLevel("L", 21, "5.0", "5.0.2", "Lemon Meringue Pie");
    public static final AndroidApiLevel L_MR1 = new AndroidApiLevel("L_MR1", 22, "5.1", "5.1.1", "Lemon Meringue Pie");
    public static final AndroidApiLevel M = new AndroidApiLevel("M", 23, "6.0", "6.0.1", "Macadamia Nut Cookie");
    public static final AndroidApiLevel N = new AndroidApiLevel("N", 24, "7.0", "New York Cheesecake");
    public static final AndroidApiLevel N_MR1 = new AndroidApiLevel("N_MR1", 25, "7.1", "7.1.2", "New York Cheesecake");
    public static final AndroidApiLevel O = new AndroidApiLevel("O", 26, "8.0", "Oatmeal Cookie");
    public static final AndroidApiLevel O_MR1 = new AndroidApiLevel("O_MR1", 27, "8.1", "Oatmeal Cookie");
    public static final AndroidApiLevel P = new AndroidApiLevel("P", 28, "9", "Pistachio Ice Cream");
    public static final AndroidApiLevel Q = new AndroidApiLevel("Q", 29, "10", "Quince Tart");
    public static final AndroidApiLevel R = new AndroidApiLevel("R", 30, "11", "Red Velvet Cake");
    public static final AndroidApiLevel S = new AndroidApiLevel("S", 31, "12", "Snow Cone");
    public static final AndroidApiLevel Sv2 = new AndroidApiLevel("Sv2", 32, "12.1", "Snow Cone v2");
    public static final AndroidApiLevel T = new AndroidApiLevel("T", 33, "13", "Tiramisu");
    public static final AndroidApiLevel U = new AndroidApiLevel("U", 34, "14", "Upside Down Cake");
    public static final AndroidApiLevel V = new AndroidApiLevel("V", 35, "15", "Vanilla Ice Cream");
    public static final AndroidApiLevel ANDROID_PLATFORM = new AndroidApiLevel("ANDROID_PLATFORM", 10000, "10000", "ANDROID_PLATFORM");
    private static final AndroidApiLevel[] VALUES;
    public static final AndroidApiLevel LATEST;
    private final String name;
    private final int api;
    private final String version;
    private final String versionMax;
    private final String description;

    private AndroidApiLevel(String name, int api, String version, String versionMax, String description) {
        this.name = name;
        this.api = api;
        this.version = version;
        this.versionMax = versionMax;
        this.description = description;
    }

    private AndroidApiLevel(String name, int api, String version, String description) {
        this(name, api, version, null, description);
    }

    public int getApi() {
        return this.api;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionMax() {
        return this.versionMax;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(AndroidApiLevel apiLevel) {
        return Integer.compare(this.api, apiLevel.api);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.api;
    }

    public String toString() {
        return this.name + "-" + this.api + " (" + this.description + " - " + this.version + ")";
    }

    public static AndroidApiLevel forApi(int api) {
        for (AndroidApiLevel level : VALUES) {
            if (api != level.getApi()) continue;
            return level;
        }
        return null;
    }

    public static AndroidApiLevel getMinAndroidApiLevelForDex(int dexVersion) {
        switch (dexVersion) {
            case 35: {
                return B;
            }
            case 37: {
                return N;
            }
            case 38: {
                return O;
            }
            case 39: {
                return P;
            }
            case 40: {
                return R;
            }
            case 41: {
                return ANDROID_PLATFORM;
            }
        }
        return null;
    }

    public static AndroidApiLevel[] values() {
        return (AndroidApiLevel[])VALUES.clone();
    }

    static {
        LATEST = U;
        VALUES = new AndroidApiLevel[]{B, B_1_1, C, D, E, E_0_1, E_MR1, F, G, G_MR1, H, H_MR1, H_MR2, I, I_MR1, J, J_MR1, J_MR2, K, K_WATCH, L, L_MR1, M, N, N_MR1, O, O_MR1, P, Q, R, S, Sv2, T, U, V, ANDROID_PLATFORM};
    }
}

