/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.smali;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.DexDecoder;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.apkeditor.smali.ResourceComment;
import com.reandroid.arsc.chunk.TableBlock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.jf.baksmali.Baksmali;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

public class SmaliDecompiler
implements DexDecoder {
    private final TableBlock tableBlock;
    private final DecompileOptions decompileOptions;
    private ResourceComment mComment;
    private APKLogger apkLogger;

    public SmaliDecompiler(TableBlock tableBlock, DecompileOptions decompileOptions) {
        this.tableBlock = tableBlock;
        this.decompileOptions = decompileOptions;
    }

    @Deprecated
    public SmaliDecompiler(TableBlock tableBlock) {
        this(tableBlock, new DecompileOptions());
    }

    @Override
    public boolean decodeDex(DexFileInputSource inputSource, File mainDir) throws IOException {
        this.logMessage("Baksmali: " + inputSource.getAlias());
        this.disassembleDexFile(inputSource, mainDir);
        File cache = new File(mainDir, ".cache");
        cache = new File(cache, inputSource.getAlias());
        inputSource.write(cache);
        return true;
    }

    private void disassembleDexFile(DexFileInputSource inputSource, File mainDir) throws IOException {
        File dir = this.toOutDir(inputSource, mainDir);
        BaksmaliOptions options = new BaksmaliOptions();
        options.localsDirective = true;
        options.sequentialLabels = true;
        options.skipDuplicateLineNumbers = true;
        options.debugInfo = !this.decompileOptions.noDexDebug;
        options.dumpMarkers = this.decompileOptions.dexMarkers;
        options.setCommentProvider(this.getComment());
        DexBackedDexFile dexFile = this.getInputDexFile(inputSource, options);
        Baksmali.disassembleDexFile(dexFile, dir, 1, options);
    }

    private File toOutDir(DexFileInputSource inputSource, File mainDir) {
        String name = "classes";
        int num = inputSource.getDexNumber();
        if (num != 0) {
            name = name + num;
        }
        File dir = new File(mainDir, "smali");
        if (!(dir = new File(dir, name)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private DexBackedDexFile getInputDexFile(DexFileInputSource inputSource, BaksmaliOptions options) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        inputSource.write(outputStream);
        outputStream.close();
        return new DexBackedDexFile(Opcodes.forApi(options.apiLevel), outputStream.toByteArray());
    }

    public ResourceComment getComment() {
        ResourceComment comment = this.mComment;
        if (comment == null && this.tableBlock != null) {
            this.mComment = comment = new ResourceComment(this.tableBlock);
        }
        return this.mComment;
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }
}

