/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class RefactorOptions
extends Options {
    public File publicXml;
    public boolean fixTypeNames;
    public boolean cleanMeta;
    private static final String ARG_public_xml = "-public-xml";
    private static final String ARG_DESC_public_xml = "Path of resource ids xml file (public.xml)\nLoads names and applies to resources from 'public.xml' file";
    private static final String ARG_fix_types = "-fix-types";
    private static final String ARG_DESC_fix_types = "Corrects resource type names based on usages and values";

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseOutput(args);
        this.parsePublicXml(args);
        this.parseFixTypes(args);
        this.parseKeepMeta(args);
        super.parse(args);
    }

    private void parseKeepMeta(String[] args) throws ARGException {
        this.cleanMeta = this.containsArg("-clean-meta", true, args);
    }

    private void parseFixTypes(String[] args) throws ARGException {
        this.fixTypeNames = this.containsArg(ARG_fix_types, true, args);
    }

    private void parsePublicXml(String[] args) throws ARGException {
        this.publicXml = null;
        File file = this.parseFile(ARG_public_xml, args);
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.publicXml = file;
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile("-o", args);
        if (file == null) {
            file = this.getOutputApkFromInput(this.inputFile);
        }
        this.outputFile = file;
    }

    private File getOutputApkFromInput(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_refactored.apk";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input file");
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.inputFile = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("      Input: ").append(this.inputFile);
        builder.append("\n    Output: ").append(this.outputFile);
        if (this.publicXml != null) {
            builder.append("\n PublicXml: ").append(this.publicXml);
        }
        if (this.force) {
            builder.append("\n Force: true");
        }
        if (this.cleanMeta) {
            builder.append("\n Keep meta: true");
        }
        builder.append("\n ---------------------------- ");
        return builder.toString();
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Refactors obfuscated resource names");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}, {ARG_public_xml, ARG_DESC_public_xml}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{ARG_fix_types, ARG_DESC_fix_types}, {"-f", "force delete output path"}, {"-clean-meta", "cleans META-INF directory along with signature block"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("x").append(" ").append("-i").append(" path/to/input.apk");
        builder.append(" ").append("-o").append(" path/to/out.apk");
        return builder.toString();
    }
}

