/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.refactor.AutoRefactor;
import com.reandroid.apkeditor.refactor.PublicXmlRefactor;
import com.reandroid.apkeditor.refactor.RefactorOptions;
import com.reandroid.apkeditor.refactor.StringValueNameGenerator;
import com.reandroid.apkeditor.refactor.TypeNameRefactor;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.commons.command.ARGException;
import java.io.File;
import java.io.IOException;

public class Refactor
extends BaseCommand<RefactorOptions> {
    public static final String ARG_SHORT = "x";
    public static final String ARG_LONG = "refactor";
    public static final String DESCRIPTION = "Refactors obfuscated resource names";

    public Refactor(RefactorOptions options) {
        super(options, "[REFACTOR] ");
    }

    @Override
    public void run() throws IOException {
        RefactorOptions options = (RefactorOptions)this.getOptions();
        this.logMessage("Loading apk: " + options.inputFile);
        ApkModule module = ApkModule.loadApkFile(this, options.inputFile, new File[0]);
        if (!module.hasTableBlock()) {
            throw new IOException("Don't have " + TableBlock.FILE_NAME);
        }
        String protect = Util.isProtected(module);
        if (protect != null) {
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        if (options.fixTypeNames) {
            TypeNameRefactor typeNameRefactor = new TypeNameRefactor(module);
            typeNameRefactor.setApkLogger(this);
            typeNameRefactor.refactor();
        }
        if (options.publicXml != null) {
            this.logMessage("Renaming from: " + options.publicXml);
            PublicXmlRefactor publicXmlRefactor = new PublicXmlRefactor(module, options.publicXml);
            publicXmlRefactor.refactor();
        } else {
            this.logMessage("Auto refactoring ...");
            AutoRefactor autoRefactor = new AutoRefactor(module);
            autoRefactor.refactor();
            this.logMessage("Auto renamed entries");
            StringValueNameGenerator generator = new StringValueNameGenerator(module.getTableBlock());
            generator.refactor();
        }
        if (options.cleanMeta) {
            this.logMessage("Clearing META-INF ...");
            Refactor.clearMeta(module);
        }
        Util.addApkEditorInfo(module, this.getClass().getSimpleName());
        String message = module.refreshTable();
        if (message != null) {
            this.logMessage(message);
        }
        this.logMessage("Writing apk ...");
        module.writeApk(options.outputFile);
        this.logMessage("Saved to: " + options.outputFile);
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(RefactorOptions.getHelp());
        }
        RefactorOptions option = new RefactorOptions();
        option.parse(args);
        File outFile = option.outputFile;
        Util.deleteEmptyDirectories(outFile);
        Refactor refactor = new Refactor(option);
        if (outFile.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outFile);
            }
            refactor.logMessage("Deleting: " + outFile);
            Util.deleteDir(outFile);
        }
        refactor.logMessage("Refactoring ...\n" + option);
        refactor.run();
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

