/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.identifiers.TableIdentifier;
import java.io.File;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class PublicXmlRefactor {
    private final ApkModule apkModule;
    private final File pubXmlFile;
    private APKLogger apkLogger;

    public PublicXmlRefactor(ApkModule apkModule, File pubXmlFile) {
        this.apkModule = apkModule;
        this.pubXmlFile = pubXmlFile;
        this.apkLogger = apkModule.getApkLogger();
    }

    public void refactor() throws IOException {
        this.logMessage("Loading: " + this.pubXmlFile);
        TableIdentifier tableIdentifier = new TableIdentifier();
        try {
            tableIdentifier.loadPublicXml(this.pubXmlFile);
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
        this.logMessage("Applying from public xml ...");
        tableIdentifier.setTableBlock(this.apkModule.getTableBlock());
        int count = tableIdentifier.renameSpecs();
        if (count == 0) {
            this.logMessage("Nothing renamed !");
        }
        this.logMessage("Renamed: " + count);
        this.apkModule.getTableBlock().removeUnusedSpecs();
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }

    void logError(String msg, Throwable tr) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger == null || msg == null && tr == null) {
            return;
        }
        apkLogger.logError(msg, tr);
    }

    void logVerbose(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logVerbose(msg);
        }
    }
}

