/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.archive.block.CertificateBlock;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.Marker;
import com.reandroid.json.JSONObject;
import com.reandroid.json.JSONWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class InfoWriterJson
extends InfoWriter {
    private final JSONWriter mJsonWriter;

    public InfoWriterJson(Writer writer) {
        super(writer);
        JSONWriter jsonWriter = new JSONWriter(writer);
        this.mJsonWriter = jsonWriter = jsonWriter.array();
    }

    @Override
    public void writeCertificates(List<CertificateBlock> certificateList, boolean base64) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key("certificates").array();
        for (CertificateBlock certificateBlock : certificateList) {
            JSONObject jsonObject = certificateBlock.toJson();
            if (base64) {
                jsonObject.put("base64", InfoWriterJson.toBase64(certificateBlock.getCertificateBytes()));
            }
            jsonWriter.value(jsonObject);
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeDexInfo(DexFile dexFile, boolean writeSectionInfo) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key("name").value(dexFile.getFileName()).key("version").value(dexFile.getVersion()).key("markers").array();
        List<Marker> markersList = dexFile.getMarkers();
        for (Marker marker : markersList) {
            jsonWriter.value(marker.getJsonObject());
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        packageBlock.sortTypes();
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(packageBlock.getId()).key("package").value(packageBlock.getName()).key("types").array();
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            if (!this.contains(specTypePair, typeFilters)) continue;
            this.writeResources(specTypePair, writeEntries);
        }
        jsonWriter.endArray().endObject();
    }

    public void writeResources(SpecTypePair specTypePair, boolean writeEntries) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(specTypePair.getId()).key("type").value(specTypePair.getTypeName()).key("entries").array();
        Iterator<ResourceEntry> iterator = specTypePair.getResources();
        while (iterator.hasNext()) {
            ResourceEntry resourceEntry = iterator.next();
            this.writeResources(resourceEntry, writeEntries);
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeResources(ResourceEntry resourceEntry, boolean writeEntries) throws IOException {
        if (resourceEntry.isEmpty()) {
            return;
        }
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(resourceEntry.getResourceId()).key("type").value(resourceEntry.getType()).key("name").value(resourceEntry.getName());
        if (writeEntries) {
            jsonWriter.key("configs");
            this.writeEntries(resourceEntry);
        }
        jsonWriter.endObject();
    }

    public void writeEntries(ResourceEntry entryList) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.array();
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
        jsonWriter.endArray();
    }

    public void writeEntry(Entry entry) throws IOException {
        if (entry.isComplex()) {
            this.writeBagEntry(entry);
        } else {
            this.writeResEntry(entry);
        }
    }

    private void writeResEntry(Entry entry) throws IOException {
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return;
        }
        this.mJsonWriter.object().key("qualifiers").value(entry.getResConfig().getQualifiers()).key("value").value(InfoWriterJson.getValueAsString(resValue)).endObject();
    }

    private void writeBagEntry(Entry entry) {
        ResValueMapArray mapArray = entry.getResValueMapArray();
        JSONWriter jsonWriter = this.mJsonWriter.object().key("qualifiers").value(entry.getResConfig().getQualifiers()).key("size").value(mapArray.size()).key("parent").value(((ResTableMapEntry)entry.getTableEntry()).getParentId()).key("bag").array();
        for (ResValueMap resValueMap : (ResValueMap[])mapArray.getChildes()) {
            this.writeValueMap(resValueMap);
        }
        jsonWriter.endArray().endObject();
    }

    private void writeValueMap(ResValueMap resValueMap) {
        this.mJsonWriter.object().key("name").value(resValueMap.decodeName()).key("id").value(resValueMap.getNameId()).key("value").value(InfoWriterJson.getValueAsString(resValueMap)).endObject();
    }

    @Override
    public void writePackageNames(Collection<PackageBlock> packageBlocks) throws IOException {
        if (packageBlocks == null || packageBlocks.size() == 0) {
            return;
        }
        JSONWriter jsonWriter = this.mJsonWriter.object().key("resource-packages").array();
        for (PackageBlock packageBlock : packageBlocks) {
            jsonWriter.object().key("id").value(packageBlock.getId()).key("name").value(packageBlock.getName()).endObject();
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeEntries(String name, List<Entry> entryList) throws IOException {
        if (entryList == null || entryList.size() == 0) {
            return;
        }
        Entry first = entryList.get(0);
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(first.getResourceId()).key("type").value(first.getTypeName()).key("name").value(first.getName()).key("entries").array();
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeArray(String name, Object[] values) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key(name).array();
        for (Object value : values) {
            jsonWriter.value(value);
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeNameValue(String name, Object value) throws IOException {
        this.mJsonWriter.object().key(name).value(value).endObject();
        this.getWriter().flush();
    }

    @Override
    public void flush() throws IOException {
        Writer writer = this.getWriter();
        this.mJsonWriter.endArray();
        writer.write("\n");
        writer.flush();
    }
}

