/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InfoOptions
extends Options {
    public boolean verbose = true;
    public boolean packageName = true;
    public boolean versionCode = true;
    public boolean versionName = true;
    public boolean minSdkVersion = true;
    public boolean targetSdkVersion = true;
    public boolean appName = true;
    public boolean appIcon = true;
    public boolean appRoundIcon = true;
    public boolean permissions = true;
    public boolean appClass = true;
    public boolean activities = true;
    public final List<String> resList = new ArrayList<String>();
    public boolean resources = false;
    public final List<String> typeFilterList = new ArrayList<String>();
    public boolean dex = false;
    public boolean signatures = false;
    public boolean signatures_base64 = false;
    protected static final String ARG_output = "-o";
    protected static final String ARG_DESC_output = "Output path, default is print to std stream.";
    private static final String ARG_type = "-t";
    private static final String ARG_DESC_type = "Print type, options:\n  1) TEXT\n  2) JSON\n  3) XML\n   default=TEXT";
    private static final String ARG_verbose = "-v";
    private static final String ARG_DESC_verbose = "Verbose mode.";
    private static final String ARG_package = "-package";
    private static final String ARG_DESC_package = "Package name(s) from manifest and if verbose mode, prints resource table packages.";
    private static final String ARG_version_code = "-version-code";
    private static final String ARG_DESC_version_code = "App version code.";
    private static final String ARG_version_name = "-version-name";
    private static final String ARG_DESC_version_name = "App version name.";
    private static final String ARG_min_sdk_version = "-min-sdk-version";
    private static final String ARG_DESK_min_sdk_version = "Minimum SDK version";
    private static final String ARG_target_sdk_version = "-target-sdk-version";
    private static final String ARG_DESK_target_sdk_version = "Target SDK version";
    private static final String ARG_app_name = "-app-name";
    private static final String ARG_DESC_app_name = "App name. If verbose mode, prints all configurations.";
    private static final String ARG_app_icon = "-app-icon";
    private static final String ARG_DESC_app_icon = "App icon path/value. If verbose mode, prints all configurations.";
    private static final String ARG_app_round_icon = "-app-round-icon";
    private static final String ARG_DESC_app_round_icon = "App round icon path/value. If verbose mode, prints all configurations.";
    private static final String ARG_permissions = "-permissions";
    private static final String ARG_DESC_permissions = "Permissions.";
    private static final String ARG_app_class = "-app-class";
    private static final String ARG_DESC_app_class = "Application class name.";
    private static final String ARG_activities = "-activities";
    private static final String ARG_DESC_activities = "Prints main activity class name. If verbose mode, prints all declared activities including <activity-alias>.";
    private static final String ARG_res = "-res";
    private static final String ARG_DESC_res = "Prints resource entries specified by either of:\n  1) Hex or decimal resource id.\n  2) Full resource name e.g @string/app_name.\n  *Can be multiple";
    private static final String ARG_resources = "-resources";
    private static final String ARG_DESC_resources = "Prints all resources.";
    private static final String ARG_filter_type = "-filter-type";
    private static final String ARG_DESC_filter_type = "Prints only the specified resource type names\n  *This applies only when flag '-resources' used.\n  *Can be multiple";
    private static final String ARG_dex = "-dex";
    private static final String ARG_DESC_dex = "Prints dex information";
    private static final String ARG_signatures = "-signatures";
    private static final String ARG_DESC_signatures = "Prints signature information";
    private static final String ARG_signatures_base64 = "-signatures-base64";
    private static final String ARG_DESC_signatures_base64 = "Prints signature information with base64 certificates";
    private static final String[] availableTypes = new String[]{"text", "json", "xml"};

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.verbose = this.containsArg(ARG_verbose, args);
        this.type = this.parseType(ARG_type, args, availableTypes, "text");
        this.parseOutput(args);
        this.initializeDefaults(args);
        this.parseResList(args);
        this.parseResourceFilterList(args);
        this.parseFrameworks(args);
        this.packageName = this.containsArg(ARG_package, args, this.packageName);
        this.versionCode = this.containsArg(ARG_version_code, args, this.versionCode);
        this.versionName = this.containsArg(ARG_version_name, args, this.versionName);
        this.minSdkVersion = this.containsArg(ARG_min_sdk_version, args, this.minSdkVersion);
        this.targetSdkVersion = this.containsArg(ARG_target_sdk_version, args, this.targetSdkVersion);
        this.appName = this.containsArg(ARG_app_name, args, this.appName);
        this.appIcon = this.containsArg(ARG_app_icon, args, this.appIcon);
        this.appRoundIcon = this.containsArg(ARG_app_round_icon, args, this.appRoundIcon);
        this.permissions = this.containsArg(ARG_permissions, args, this.permissions);
        this.appClass = this.containsArg(ARG_app_class, args, this.appClass);
        this.activities = this.containsArg(ARG_activities, args, this.activities);
        this.resources = this.containsArg(ARG_resources, args, false);
        this.dex = this.containsArg(ARG_dex, args, false);
        this.signatures = this.containsArg(ARG_signatures, args, false);
        this.signatures_base64 = this.containsArg(ARG_signatures_base64, args, false);
        this.parseHelp(args);
        super.checkUnknownOptions(args);
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile(ARG_output, args);
        if (file == null) {
            return;
        }
        String name = file.getName().toLowerCase();
        String ext = "text".equals(this.type) ? (name.endsWith(".text") ? ".text" : ".txt") : "." + this.type.toLowerCase();
        if (!name.endsWith(ext)) {
            throw new ARGException("Invalid file extension! Expected = \"" + ext + "\", " + file);
        }
        this.outputFile = file;
    }

    private void parseResourceFilterList(String[] args) throws ARGException {
        String filter;
        while ((filter = this.parseArgValue(ARG_filter_type, args)) != null) {
            this.typeFilterList.add(filter);
        }
    }

    private void parseResList(String[] args) throws ARGException {
        String res;
        while ((res = this.parseArgValue(ARG_res, args)) != null) {
            this.resList.add(res);
            this.verbose = true;
        }
    }

    private void initializeDefaults(String[] args) {
        this.resources = false;
        if (!Util.isEmpty(args)) {
            this.packageName = false;
            this.versionCode = false;
            this.versionName = false;
            this.minSdkVersion = false;
            this.targetSdkVersion = false;
            this.appName = false;
            this.appIcon = false;
            this.appRoundIcon = false;
            this.permissions = false;
            this.activities = false;
            this.appClass = false;
            this.dex = false;
        }
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input apk! Specify with  -i");
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.inputFile = file;
    }

    private void parseHelp(String[] args) throws ARGException {
        if (!Util.containsHelp(args)) {
            return;
        }
        throw new ARGException(InfoOptions.getHelp());
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Prints information of apk");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {ARG_type, ARG_DESC_type}, {ARG_output, ARG_DESC_output}, {ARG_res, ARG_DESC_res}, {ARG_filter_type, ARG_DESC_filter_type}, {"-framework", "path of framework file (can be multiple)"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\n\nFlags:\n");
        table = new String[][]{{ARG_verbose, ARG_DESC_verbose}, {ARG_package, ARG_DESC_package}, {ARG_version_code, ARG_DESC_version_code}, {ARG_version_name, ARG_DESC_version_name}, {ARG_min_sdk_version, ARG_DESK_min_sdk_version}, {ARG_target_sdk_version, ARG_DESK_target_sdk_version}, {ARG_app_name, ARG_DESC_app_name}, {ARG_app_icon, ARG_DESC_app_icon}, {ARG_app_round_icon, ARG_DESC_app_round_icon}, {ARG_app_class, ARG_DESC_app_class}, {ARG_permissions, ARG_DESC_permissions}, {ARG_activities, ARG_DESC_activities}, {ARG_resources, ARG_DESC_resources}, {"  ", "  "}, {ARG_dex, ARG_DESC_dex}, {ARG_signatures, ARG_DESC_signatures}, {ARG_signatures_base64, ARG_DESC_signatures_base64}, {"  ", "  "}, {"-h|-help", "Prints this help"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\n").append("    ------------------------------------------------------------------------");
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("info").append(" ").append("-i").append(" file.apk");
        builder.append("\n\nExample-2:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("info").append(" ").append("-i").append(" file.apk");
        builder.append(" ").append(ARG_type).append(" ").append("json".toUpperCase());
        builder.append(" ").append(ARG_verbose);
        builder.append(" ").append(ARG_output).append(" info_file.json");
        builder.append("\n\nExample-3:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("info").append(" ").append("-i").append(" file.apk ").append(ARG_resources).append(" ").append(ARG_filter_type).append(" ").append("mipmap").append(" ").append(ARG_filter_type).append(" ").append("drawable");
        builder.append("\n\nExample-4:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("info").append(" ").append("-i").append(" file.apk ").append(ARG_verbose).append(" ").append(ARG_res).append(" ").append("@string/app_name").append(" ").append(ARG_res).append(" ").append("0x7f010000");
        return builder.toString();
    }
}

