/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.decompile;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class DecompileOptions
extends Options {
    public boolean splitJson;
    public boolean validateResDir;
    public String resDirName;
    public boolean keepResPath;
    public boolean dex;
    public boolean noDexDebug;
    public boolean dexMarkers;
    private static final String ARG_split_resources = "-split-json";
    private static final String ARG_DESC_split_resources = "splits resources.arsc into multiple parts as per type entries (use this for large files)";
    private static final String ARG_DESC_type = "Decode types: \n  1) json \n  2) xml \n  3) raw \n  4) sig \n default=xml";
    private static final String ARG_keep_res_path = "-keep-res-path";
    private static final String ARG_DESC_keep_res_path = "Keeps original res/* file paths:\n  *Applies only when decoding to xml\n  *All res/* files will be placed on dir <res-files>\n  *The relative paths will be linked to values/*xml";
    private static final String ARG_dex = "-dex";
    private static final String ARG_DESC_dex = "Copy raw dex files / skip smali";
    private static final String ARG_no_dex_debug = "-no-dex-debug";
    private static final String ARG_DESC_no_dex_debug = "Drops all debug info from smali/dex";
    private static final String ARG_dex_markers = "-dex-markers";
    private static final String ARG_DESC_dex_markers = "Dumps dex markers (applies only when smali mode)";

    public DecompileOptions() {
        this.type = "xml";
    }

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseType(args, this.type);
        this.parseOutput(args);
        this.parseSplitResources(args);
        this.parseNoDexDebug(args);
        this.parseDexMarkers(args);
        this.parseDex(args);
        this.parseKeepResPath(args);
        this.parseResDirName(args);
        this.parseValidateResDir(args);
        this.parseSignaturesDir(args);
        if (this.signaturesDirectory == null && this.type == null) {
            this.type = "xml";
        }
        super.parse(args);
    }

    private void parseKeepResPath(String[] args) {
        this.keepResPath = this.containsArg(ARG_keep_res_path, true, args);
    }

    private void parseValidateResDir(String[] args) {
        this.validateResDir = this.containsArg("-vrd", true, args);
    }

    private void parseResDirName(String[] args) throws ARGException {
        this.resDirName = this.parseArgValue("-res-dir", true, args);
    }

    private void parseSplitResources(String[] args) {
        this.splitJson = this.containsArg(ARG_split_resources, true, args);
    }

    private void parseNoDexDebug(String[] args) {
        this.noDexDebug = this.containsArg(ARG_no_dex_debug, true, args);
    }

    private void parseDexMarkers(String[] args) {
        this.dexMarkers = this.containsArg(ARG_dex_markers, true, args);
    }

    private void parseDex(String[] args) {
        this.dex = this.containsArg(ARG_dex, true, args);
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile("-o", args);
        if (file == null) {
            file = this.getOutputFromInput(this.inputFile);
        }
        this.outputFile = file;
    }

    private File getOutputFromInput(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_decompile_" + this.type;
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input file");
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.inputFile = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   Input: ").append(this.inputFile);
        File out = this.signaturesDirectory != null ? this.signaturesDirectory : this.outputFile;
        builder.append("\n Output: ").append(out);
        if (this.resDirName != null) {
            builder.append("\nres dir: ").append(this.resDirName);
        }
        if (this.validateResDir) {
            builder.append("\n Validate res dir name: true");
        }
        if (this.force) {
            builder.append("\n Force: true");
        }
        if (this.keepResPath) {
            builder.append("\n Keep res path: true");
        }
        if (this.frameworkVersion != null) {
            builder.append("\nFramework version: ").append(this.frameworkVersion);
        }
        builder.append("\n Type: ").append(this.type);
        if (!"xml".equals(this.type) && this.signaturesDirectory == null) {
            builder.append("\n Split: ").append(this.splitJson);
        }
        if (this.frameworks != null && this.frameworks.length > 0) {
            builder.append("\nFrameworks:");
            for (File file : this.frameworks) {
                builder.append("\n           ");
                builder.append(file);
            }
        }
        builder.append("\n ---------------------------- ");
        return builder.toString();
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Decodes android resources binary to readable json/xml");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}, {"-framework-version", "preferred framework version number"}, {"-framework", "path of framework file (can be multiple)"}, {"-sig", "signatures directory path"}, {"-t", ARG_DESC_type}, {"-res-dir", "sets resource files root dir name\n(eg. for obfuscation to move files from 'res/*' to 'r/*' or vice versa)"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{ARG_dex, ARG_DESC_dex}, {"-f", "force delete output path"}, {ARG_keep_res_path, ARG_DESC_keep_res_path}, {ARG_split_resources, ARG_DESC_split_resources}, {"-vrd", "validate resources dir name\n(eg. if a drawable resource file path is 'res/abc.png' then\nit will be moved to 'res/drawable/abc.png')"}, {ARG_no_dex_debug, ARG_DESC_no_dex_debug}, {ARG_dex_markers, ARG_DESC_dex_markers}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("d").append(" ").append("-i").append(" path/to/input.apk");
        builder.append(" ").append("-o").append(" path/to/out_dir");
        builder.append("\nExample-2:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("d").append(" ").append("-i").append(" path/to/input.apk");
        builder.append("\nExample-3:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("d").append(" ").append("-i").append(" path/to/input.apk").append(" ").append(ARG_split_resources);
        builder.append("\nExample-4: (XML)");
        builder.append("\n   java -jar ").append(jar).append(" ").append("d").append(" ").append("-t").append(" ").append("xml").append(" ").append("-i").append(" path/to/input.apk");
        builder.append("\nExample-5: (signatures)");
        builder.append("\n   java -jar ").append(jar).append(" ").append("d").append(" ").append("-t").append(" ").append("sig").append(" ").append("-i").append(" path/to/input.apk").append(" ").append("-sig").append(" path/to/signatures_dir");
        builder.append("\nExample-6: (framework)");
        builder.append("\n   java -jar ").append(jar).append(" ").append("d").append(" ").append("-i").append(" input.apk");
        builder.append(" ").append("-framework").append(" framework-res.apk");
        builder.append(" ").append("-framework").append(" platforms/android-32/android.jar");
        return builder.toString();
    }
}

