/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.framework;

import com.reandroid.apk.AndroidFrameworks;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.framework.FrameworkManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class InternalFrameworks
extends FrameworkManager {
    public static final InternalFrameworks INSTANCE = new InternalFrameworks();
    private Map<Integer, String> resourcePaths;
    private static final String ANDROID_RESOURCE_DIRECTORY = "/frameworks/android/";
    private static final String ANDROID_PACKAGE = "android";
    private static final String FRAMEWORK_EXTENSION = ".apk";

    private InternalFrameworks() {
    }

    @Override
    public FrameworkApk get(int version) {
        return null;
    }

    @Override
    public FrameworkApk getBestMatch(int version) {
        Integer nearest = this.getNearestVersion(version);
        if (nearest == null) {
            return null;
        }
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            int best = nearest;
            FrameworkApk current = this.getCurrent();
            if (current != null && best == current.getVersionCode()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return current;
            }
            try {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.loadResource(best);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameworkApk getLatest() {
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            FrameworkApk frameworkApk;
            int latest = this.getLatestVersion();
            FrameworkApk current = this.getCurrent();
            if (current != null && latest == current.getVersionCode()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return current;
            }
            try {
                frameworkApk = this.loadResource(latest);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            if (current == null) {
                this.setCurrent(frameworkApk);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return frameworkApk;
        }
    }

    @Override
    public Integer getNearestVersion(int version) {
        Map<Integer, String> pathMap = this.getResourcePaths();
        if (pathMap.containsKey(version)) {
            return version;
        }
        int highest = 0;
        int best = 0;
        int prevDifference = 0;
        for (int id : pathMap.keySet()) {
            int diff;
            if (highest == 0) {
                highest = id;
                best = id;
                prevDifference = version * 2 + 1000;
                continue;
            }
            if (id > highest) {
                highest = id;
            }
            if ((diff = id - version) < 0) {
                diff = -diff;
            }
            if (diff >= prevDifference && (diff != prevDifference || id <= best)) continue;
            best = id;
            prevDifference = diff;
        }
        return best;
    }

    @Override
    public Integer getLatestVersion() {
        Map<Integer, String> pathMap = this.getResourcePaths();
        int highest = 0;
        for (int id : pathMap.keySet()) {
            if (highest == 0) {
                highest = id;
                continue;
            }
            if (id <= highest) continue;
            highest = id;
        }
        return highest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, String> getResourcePaths() {
        if (this.resourcePaths != null) {
            return this.resourcePaths;
        }
        InternalFrameworks internalFrameworks = this;
        synchronized (internalFrameworks) {
            this.resourcePaths = this.scanAvailableResourcePaths();
            return this.resourcePaths;
        }
    }

    private FrameworkApk loadResource(int version) throws IOException {
        String path = this.getResourcePaths().get(version);
        if (path == null) {
            throw new IOException("No resource found for version: " + version);
        }
        String simpleName = InternalFrameworks.toSimpleName(path);
        return FrameworkApk.loadApkBuffer(simpleName, AndroidFrameworks.class.getResourceAsStream(path));
    }

    private Map<Integer, String> scanAvailableResourcePaths() {
        HashMap<Integer, String> results = new HashMap<Integer, String>();
        int maxSearch = 35;
        for (int version = 21; version < maxSearch; ++version) {
            String path = InternalFrameworks.toResourcePath(version);
            if (!InternalFrameworks.isAvailable(path)) continue;
            results.put(version, path);
            if (version + 1 != maxSearch) continue;
            ++maxSearch;
        }
        return results;
    }

    private static String toSimpleName(String path) {
        int i = path.lastIndexOf(47);
        if (i < 0) {
            i = path.lastIndexOf(File.separatorChar);
        }
        if (i > 0) {
            path = path.substring(++i);
        }
        if ((i = path.lastIndexOf(46)) >= 0) {
            path = path.substring(0, i);
        }
        return path;
    }

    private static boolean isAvailable(String path) {
        InputStream inputStream = InternalFrameworks.class.getResourceAsStream(path);
        if (inputStream == null) {
            return false;
        }
        InternalFrameworks.closeQuietly(inputStream);
        return true;
    }

    private static void closeQuietly(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String toResourcePath(int version) {
        return "/frameworks/android/android-" + version + FRAMEWORK_EXTENSION;
    }
}

