/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.JsonStringPoolBuilder;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.StagedAlias;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class TableBlockJsonBuilder {
    private final JsonStringPoolBuilder poolBuilder = new JsonStringPoolBuilder();

    public TableBlock scanDirectory(File resourcesDir) throws IOException {
        if (!resourcesDir.isDirectory()) {
            throw new IOException("No such directory: " + resourcesDir);
        }
        List<File> packageDirectories = ApkUtil.listPackageDirectories(resourcesDir);
        if (packageDirectories.size() == 0) {
            throw new IOException("No package sub directory found in : " + resourcesDir);
        }
        TableBlock tableBlock = new TableBlock();
        this.poolBuilder.scanDirectory(resourcesDir);
        this.poolBuilder.apply(tableBlock);
        for (File packageDir : packageDirectories) {
            this.scanPackageDirectory(tableBlock, packageDir);
        }
        tableBlock.sortPackages();
        tableBlock.refresh();
        return tableBlock;
    }

    private void scanPackageDirectory(TableBlock tableBlock, File packageDir) throws IOException {
        File packageJsonFile = new File(packageDir, PackageBlock.JSON_FILE_NAME);
        if (!packageJsonFile.isFile()) {
            throw new IOException("Invalid package directory! Package file missing: " + packageJsonFile);
        }
        JSONObject jsonObject = new JSONObject(packageJsonFile);
        PackageBlock packageBlock = tableBlock.getPackageArray().getOrCreate(jsonObject.getInt(PackageBlock.NAME_package_id));
        packageBlock.setName(jsonObject.optString(PackageBlock.NAME_package_name));
        if (jsonObject.has(PackageBlock.NAME_staged_aliases)) {
            JSONArray stagedJson = jsonObject.getJSONArray(PackageBlock.NAME_staged_aliases);
            StagedAlias stagedAlias = new StagedAlias();
            stagedAlias.getStagedAliasEntryArray().fromJson(stagedJson);
            packageBlock.getStagedAliasList().add(stagedAlias);
        }
        List<File> typeFileList = ApkUtil.listFiles(packageDir, ".json");
        typeFileList.remove(packageJsonFile);
        for (File typeFile : typeFileList) {
            this.loadType(packageBlock, typeFile);
        }
        packageBlock.sortTypes();
    }

    private void loadType(PackageBlock packageBlock, File typeJsonFile) throws IOException {
        JSONObject jsonObject = new JSONObject(typeJsonFile);
        ResConfig resConfig = new ResConfig();
        resConfig.fromJson(jsonObject.getJSONObject("config"));
        TypeBlock typeBlock = packageBlock.getSpecTypePairArray().getOrCreate((byte)(0xFF & jsonObject.getInt("id")), resConfig);
        typeBlock.fromJson(jsonObject);
    }
}

