/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.CrcOutputStream;
import com.reandroid.apk.JsonStringPoolBuilder;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SingleJsonTableInputSource
extends BlockInputSource<TableBlock> {
    private final InputSource inputSource;
    private TableBlock mCache;

    public SingleJsonTableInputSource(InputSource inputSource) {
        super(TableBlock.FILE_NAME, null);
        this.inputSource = inputSource;
    }

    @Override
    public TableBlock getBlock() {
        try {
            return this.getTableBlock();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return this.getTableBlock().writeBytes(outputStream);
    }

    @Override
    public InputStream openStream() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return new ByteArrayInputStream(tableBlock.getBytes());
    }

    @Override
    public long getLength() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return tableBlock.countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        CrcOutputStream outputStream = new CrcOutputStream();
        this.write(outputStream);
        return outputStream.getCrcValue();
    }

    public TableBlock getTableBlock() throws IOException {
        if (this.mCache != null) {
            return this.mCache;
        }
        TableBlock tableBlock = new TableBlock();
        InputStream inputStream = this.inputSource.openStream();
        try {
            JsonStringPoolBuilder poolBuilder = new JsonStringPoolBuilder();
            JSONObject jsonObject = new JSONObject(inputStream);
            poolBuilder.build(jsonObject);
            poolBuilder.apply(tableBlock);
            tableBlock.fromJson(jsonObject);
        }
        catch (JSONException ex) {
            throw new IOException(this.inputSource.getAlias(), ex);
        }
        this.mCache = tableBlock;
        return tableBlock;
    }

    public static SingleJsonTableInputSource fromFile(File rootDir, File jsonFile) {
        String path = ApkUtil.jsonToArchiveResourcePath(rootDir, jsonFile);
        FileInputSource fileInputSource = new FileInputSource(jsonFile, path);
        return new SingleJsonTableInputSource(fileInputSource);
    }
}

