/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkUtil;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonStringPoolBuilder {
    private final Map<Integer, Set<String>> mSpecNameMap = new HashMap<Integer, Set<String>>();
    private final Set<String> mTableStrings = new HashSet<String>();
    private int mCurrentPackageId;
    private JSONArray mStyledStrings;

    public void apply(TableBlock tableBlock) {
        this.applyTableString(tableBlock.getTableStringPool());
        for (int pkgId : this.mSpecNameMap.keySet()) {
            PackageBlock packageBlock = tableBlock.getPackageArray().getOrCreate(pkgId);
            this.applySpecString(packageBlock.getSpecStringPool());
        }
    }

    private void applyTableString(TableStringPool stringPool) {
        stringPool.fromJson(this.mStyledStrings);
        stringPool.addStrings(this.getTableString());
        stringPool.refresh();
    }

    private void applySpecString(SpecStringPool stringPool) {
        int pkgId = stringPool.getPackageBlock().getId();
        stringPool.addStrings(this.getSpecString(pkgId));
        stringPool.refresh();
    }

    public void scanDirectory(File resourcesDir) throws IOException {
        this.mCurrentPackageId = 0;
        List<File> packageDirectories = ApkUtil.listPackageDirectories(resourcesDir);
        for (File dir : packageDirectories) {
            File packageFile = new File(dir, PackageBlock.JSON_FILE_NAME);
            this.scanFile(packageFile);
            List<File> jsonFileList = ApkUtil.recursiveFiles(dir, ".json");
            for (File file : jsonFileList) {
                if (file.equals(packageFile)) continue;
                this.scanFile(file);
            }
        }
    }

    public void scanFile(File jsonFile) throws IOException {
        try {
            JSONObject jsonObject = new JSONObject(jsonFile);
            this.build(jsonObject);
        }
        catch (JSONException ex) {
            throw new IOException(jsonFile + ": " + ex.getMessage());
        }
    }

    public void build(JSONObject jsonObject) {
        this.scan(jsonObject);
    }

    public Set<String> getTableString() {
        return this.mTableStrings;
    }

    public Set<String> getSpecString(int pkgId) {
        return this.mSpecNameMap.get(pkgId);
    }

    private void scan(JSONObject jsonObject) {
        if (jsonObject.has("entry_name")) {
            this.addSpecName(jsonObject.optString("entry_name"));
        }
        if (jsonObject.has("value_type")) {
            if (ValueType.STRING.name().equals(jsonObject.getString("value_type"))) {
                String data = jsonObject.optString("data", "");
                this.addTableString(data);
            }
            return;
        }
        if (jsonObject.has(PackageBlock.NAME_package_id)) {
            this.mCurrentPackageId = jsonObject.getInt(PackageBlock.NAME_package_id);
        }
        Set<String> keyList = jsonObject.keySet();
        for (String key : keyList) {
            Object obj = jsonObject.get(key);
            if (obj instanceof JSONObject) {
                this.scan((JSONObject)obj);
                continue;
            }
            if (!(obj instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)obj;
            if (TableBlock.NAME_styled_strings.equals(key)) {
                this.mStyledStrings = jsonArray;
                continue;
            }
            this.scan(jsonArray);
        }
    }

    private void scan(JSONArray jsonArray) {
        if (jsonArray == null) {
            return;
        }
        for (Object obj : jsonArray.getArrayList()) {
            if (obj instanceof JSONObject) {
                this.scan((JSONObject)obj);
                continue;
            }
            if (!(obj instanceof JSONArray)) continue;
            this.scan((JSONArray)obj);
        }
    }

    private void addTableString(String name) {
        if (name == null) {
            return;
        }
        this.mTableStrings.add(name);
    }

    private void addSpecName(String name) {
        if (name == null) {
            return;
        }
        int pkgId = this.mCurrentPackageId;
        if (pkgId == 0) {
            throw new IllegalArgumentException("Current package id is 0");
        }
        Set<String> specNames = this.mSpecNameMap.get(pkgId);
        if (specNames == null) {
            specNames = new HashSet<String>();
            this.mSpecNameMap.put(pkgId, specNames);
        }
        specNames.add(name);
    }
}

