/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.model.FrameworkTable;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.value.CompoundEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FrameworkOptimizer {
    private final ApkModule frameworkApk;
    private APKLogger apkLogger;
    private boolean mOptimizing;

    public FrameworkOptimizer(ApkModule frameworkApk) {
        this.frameworkApk = frameworkApk;
        this.apkLogger = frameworkApk.getApkLogger();
    }

    public void optimize() {
        if (this.mOptimizing) {
            return;
        }
        this.mOptimizing = true;
        if (!this.frameworkApk.hasTableBlock()) {
            this.logMessage("Don't have: " + TableBlock.FILE_NAME);
            this.mOptimizing = false;
            return;
        }
        FrameworkTable frameworkTable = this.getFrameworkTable();
        AndroidManifestBlock manifestBlock = null;
        if (this.frameworkApk.hasAndroidManifest()) {
            manifestBlock = this.frameworkApk.getAndroidManifest();
        }
        this.optimizeTable(frameworkTable, manifestBlock);
        UncompressedFiles uncompressedFiles = this.frameworkApk.getUncompressedFiles();
        uncompressedFiles.clearExtensions();
        uncompressedFiles.clearPaths();
        this.clearFiles(this.frameworkApk.getZipEntryMap());
        this.logMessage("Optimized");
    }

    private void clearFiles(ZipEntryMap zipEntryMap) {
        int size = zipEntryMap.size();
        if (size == 2) {
            return;
        }
        this.logMessage("Removing files from: " + size);
        InputSource tableSource = zipEntryMap.getInputSource(TableBlock.FILE_NAME);
        InputSource manifestSource = zipEntryMap.getInputSource(AndroidManifestBlock.FILE_NAME);
        zipEntryMap.clear();
        if (tableSource != null) {
            tableSource.setMethod(8);
        }
        if (manifestSource != null) {
            manifestSource.setMethod(8);
        }
        zipEntryMap.add(tableSource);
        zipEntryMap.add(manifestSource);
        this.logMessage("Removed files: " + (size -= zipEntryMap.size()));
    }

    private void optimizeTable(FrameworkTable table, AndroidManifestBlock manifestBlock) {
        if (table.isOptimized()) {
            return;
        }
        this.logMessage("Optimizing ...");
        int prev = table.countBytes();
        int version = 0;
        String name = "framework";
        if (manifestBlock != null) {
            Integer code = manifestBlock.getVersionCode();
            if (code != null) {
                version = code;
            }
            name = manifestBlock.getPackageName();
            this.compressManifest(manifestBlock);
            this.backupManifestValue(manifestBlock, table);
        }
        this.logMessage("Optimizing table ...");
        table.optimize(name, version);
        long diff = prev - table.countBytes();
        long percent = diff * 100L / (long)prev;
        this.logMessage("Table size reduced by: " + percent + " %");
        this.mOptimizing = false;
    }

    private FrameworkTable getFrameworkTable() {
        TableBlock tableBlock = this.frameworkApk.getTableBlock();
        if (tableBlock instanceof FrameworkTable) {
            return (FrameworkTable)tableBlock;
        }
        FrameworkTable frameworkTable = this.toFramework(tableBlock);
        this.frameworkApk.setTableBlock(frameworkTable);
        return frameworkTable;
    }

    private FrameworkTable toFramework(TableBlock tableBlock) {
        this.logMessage("Converting to framework ...");
        BlockReader reader = new BlockReader(tableBlock.getBytes());
        FrameworkTable frameworkTable = new FrameworkTable();
        try {
            frameworkTable.readBytes(reader);
        }
        catch (IOException exception) {
            this.logError("Error re-loading framework: ", exception);
        }
        return frameworkTable;
    }

    private void compressManifest(AndroidManifestBlock manifestBlock) {
        this.logMessage("Compressing manifest ...");
        int prev = manifestBlock.countBytes();
        ResXmlElement manifest = manifestBlock.getDocumentElement();
        List<ResXmlNode> removeList = this.getManifestElementToRemove(manifest);
        for (ResXmlNode resXmlNode : removeList) {
            manifest.remove(resXmlNode);
        }
        ResXmlElement application = manifestBlock.getApplicationElement();
        if (application != null) {
            removeList = application.listXmlNodes();
            for (ResXmlNode node : removeList) {
                application.remove(node);
            }
        }
        ResXmlStringPool resXmlStringPool = manifestBlock.getStringPool();
        resXmlStringPool.removeUnusedStrings();
        manifestBlock.refresh();
        long diff = prev - manifestBlock.countBytes();
        long percent = diff * 100L / (long)prev;
        this.logMessage("Manifest size reduced by: " + percent + " %");
    }

    private List<ResXmlNode> getManifestElementToRemove(ResXmlElement manifest) {
        ArrayList<ResXmlNode> results = new ArrayList<ResXmlNode>();
        for (ResXmlNode node : manifest.listXmlNodes()) {
            ResXmlElement element;
            if (!(node instanceof ResXmlElement) || AndroidManifestBlock.TAG_application.equals((element = (ResXmlElement)node).getName())) continue;
            results.add(element);
        }
        return results;
    }

    private void backupManifestValue(AndroidManifestBlock manifestBlock, TableBlock tableBlock) {
        ResXmlAttribute attribute;
        this.logMessage("Backup manifest values ...");
        ResXmlElement application = manifestBlock.getApplicationElement();
        ResXmlAttribute iconAttribute = null;
        int iconReference = 0;
        if (application != null && (attribute = application.searchAttributeByResourceId(AndroidManifestBlock.ID_icon)) != null && attribute.getValueType() == ValueType.REFERENCE) {
            iconAttribute = attribute;
            iconReference = attribute.getData();
        }
        ResXmlElement element = manifestBlock.getDocumentElement();
        this.backupAttributeValues(tableBlock, element);
        if (iconAttribute != null) {
            iconAttribute.setTypeAndData(ValueType.REFERENCE, iconReference);
        }
    }

    private void backupAttributeValues(TableBlock tableBlock, ResXmlElement element) {
        if (element == null) {
            return;
        }
        for (ResXmlAttribute attribute : element.listAttributes()) {
            this.backupAttributeValues(tableBlock, attribute);
        }
        for (ResXmlElement child : element.listElements()) {
            this.backupAttributeValues(tableBlock, child);
        }
    }

    private void backupAttributeValues(TableBlock tableBlock, ResXmlAttribute attribute) {
        if (attribute == null) {
            return;
        }
        ValueType valueType = attribute.getValueType();
        if (valueType != ValueType.REFERENCE && valueType != ValueType.ATTRIBUTE) {
            return;
        }
        int reference = attribute.getData();
        Entry entry = this.getEntryWithValue(tableBlock, reference);
        if (entry == null || this.isReferenceEntry(entry) || entry.isComplex()) {
            return;
        }
        ResTableEntry resTableEntry = (ResTableEntry)entry.getTableEntry();
        ResValue resValue = (ResValue)resTableEntry.getValue();
        valueType = resValue.getValueType();
        if (valueType == ValueType.STRING) {
            String value = resValue.getValueAsString();
            attribute.setValueAsString(value);
        } else {
            int data = resValue.getData();
            attribute.setTypeAndData(valueType, data);
        }
    }

    private Entry getEntryWithValue(TableBlock tableBlock, int resourceId) {
        HashSet<Integer> circularReference = new HashSet<Integer>();
        return this.getEntryWithValue(tableBlock, resourceId, circularReference);
    }

    private Entry getEntryWithValue(TableBlock tableBlock, int resourceId, Set<Integer> circularReference) {
        if (circularReference.contains(resourceId)) {
            return null;
        }
        circularReference.add(resourceId);
        ResourceEntry entryGroup = tableBlock.getResource(resourceId);
        Entry entry = entryGroup.get();
        if (entry == null) {
            return null;
        }
        if (this.isReferenceEntry(entry)) {
            return this.getEntryWithValue(tableBlock, ((ResValue)entry.getTableEntry().getValue()).getData(), circularReference);
        }
        if (!entry.isNull()) {
            return entry;
        }
        Iterator<Entry> itr = entryGroup.iterator(true);
        while (itr.hasNext()) {
            entry = itr.next();
            if (this.isReferenceEntry(entry) || entry.isNull()) continue;
            return entry;
        }
        return null;
    }

    private boolean isReferenceEntry(Entry entry) {
        if (entry == null || entry.isNull()) {
            return false;
        }
        TableEntry<?, ?> tableEntry = entry.getTableEntry();
        if (tableEntry instanceof CompoundEntry) {
            return false;
        }
        if (!(tableEntry instanceof ResTableEntry)) {
            return false;
        }
        ResTableEntry resTableEntry = (ResTableEntry)tableEntry;
        ResValue resValue = (ResValue)resTableEntry.getValue();
        ValueType valueType = resValue.getValueType();
        return valueType == ValueType.REFERENCE || valueType == ValueType.ATTRIBUTE;
    }

    APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

