/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class CrcOutputStream
extends OutputStream {
    private final CRC32 crc = new CRC32();
    private long length;
    private long mCheckSum;

    public long getLength() {
        return this.length;
    }

    public long getCrcValue() {
        if (this.mCheckSum == 0L) {
            this.mCheckSum = this.crc.getValue();
        }
        return this.mCheckSum;
    }

    @Override
    public void write(int b) throws IOException {
        this.crc.update(b);
        ++this.length;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.crc.update(b, off, len);
        this.length += (long)len;
    }
}

