/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.utils.CompareUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ApkUtil {
    public static final String JSON_FILE_EXTENSION = ".json";
    public static final String RES_JSON_NAME = "res-json";
    public static final String ROOT_NAME = "root";
    public static final String DEF_MODULE_NAME = "base";
    public static final String NAME_value_type = "value_type";
    public static final String NAME_data = "data";
    public static final String SIGNATURE_DIR_NAME = "signatures";

    public static String replaceRootDir(String path, String dirName) {
        int i = path.indexOf(47) + 1;
        path = path.substring(i);
        if (dirName != null && dirName.length() > 0) {
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            path = dirName + path;
        }
        return path;
    }

    public static String jsonToArchiveResourcePath(File dir, File jsonFile) {
        String ext;
        String path = ApkUtil.toArchivePath(dir, jsonFile);
        if (path.endsWith(ext = JSON_FILE_EXTENSION)) {
            int i2 = path.length() - ext.length();
            path = path.substring(0, i2);
        }
        return path;
    }

    public static String toArchivePath(File dir, File file) {
        String dirPath = dir.getAbsolutePath() + File.separator;
        String path = file.getAbsolutePath().substring(dirPath.length());
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    public static List<File> recursiveFiles(File dir, String ext) {
        ArrayList<File> results = new ArrayList<File>();
        if (dir.isFile()) {
            if (ApkUtil.hasExtension(dir, ext)) {
                results.add(dir);
            }
            return results;
        }
        if (!dir.isDirectory()) {
            return results;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (file.isFile()) {
                if (!ApkUtil.hasExtension(file, ext)) continue;
                results.add(file);
                continue;
            }
            results.addAll(ApkUtil.recursiveFiles(file, ext));
        }
        return results;
    }

    public static List<File> recursiveFiles(File dir) {
        return ApkUtil.recursiveFiles(dir, null);
    }

    public static List<File> listDirectories(File dir) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            results.add(file);
        }
        return results;
    }

    public static List<File> listPackageDirectories(File resourcesDirectory) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = resourcesDirectory.listFiles();
        if (files == null) {
            return results;
        }
        for (File dir : files) {
            if (!ApkUtil.isPackageDirectory(dir)) continue;
            results.add(dir);
        }
        results.sort(CompareUtil.getComparableComparator());
        return results;
    }

    public static List<File> listPublicXmlFiles(File resourcesDirectory) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = resourcesDirectory.listFiles();
        if (files == null) {
            return results;
        }
        for (File dir : files) {
            List<File> resDirList = ApkUtil.listDirectories(dir);
            for (File resDir : resDirList) {
                File file = ApkUtil.getPublicXmlFile(resDir);
                if (file == null) continue;
                results.add(file);
            }
        }
        results.sort(CompareUtil.getComparableComparator());
        return results;
    }

    private static File getPublicXmlFile(File resDir) {
        if (!resDir.isDirectory()) {
            return null;
        }
        File valuesDir = new File(resDir, PackageBlock.VALUES_DIRECTORY_NAME);
        if (!valuesDir.isDirectory()) {
            return null;
        }
        File file = new File(valuesDir, PackageBlock.PUBLIC_XML);
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public static List<File> listValuesDirectory(File resDir) {
        return ApkUtil.listValuesDirectory(resDir, true);
    }

    public static List<File> listValuesDirectory(File resDir, boolean includeVariants) {
        ArrayList<File> results = new ArrayList<File>();
        if (!resDir.isDirectory()) {
            return results;
        }
        File[] files = resDir.listFiles();
        if (files == null) {
            return results;
        }
        for (File dir : files) {
            if (!dir.isDirectory() || !ApkUtil.isValuesDirectoryName(dir.getName(), includeVariants)) continue;
            results.add(dir);
        }
        results.sort(CompareUtil.getComparableComparator());
        return results;
    }

    public static boolean isValuesDirectoryName(String name, boolean checkVariant) {
        if (PackageBlock.VALUES_DIRECTORY_NAME.equals(name)) {
            return true;
        }
        if (!checkVariant) {
            return false;
        }
        return name.startsWith(PackageBlock.VALUES_DIRECTORY_NAME + "-");
    }

    private static boolean isPackageDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        return new File(dir, PackageBlock.JSON_FILE_NAME).isFile();
    }

    public static List<File> listFiles(File dir, String ext) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!file.isFile() || !ApkUtil.hasExtension(file, ext)) continue;
            results.add(file);
        }
        return results;
    }

    private static boolean hasExtension(File file, String ext) {
        if (ext == null) {
            return true;
        }
        String name = file.getName().toLowerCase();
        ext = ext.toLowerCase();
        return name.endsWith(ext);
    }

    public static String toModuleName(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }
}

