/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.JsonManifestInputSource;
import com.reandroid.apk.JsonXmlInputSource;
import com.reandroid.apk.SingleJsonTableInputSource;
import com.reandroid.apk.SplitJsonTableInputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ApkModuleJsonEncoder
extends ApkModuleEncoder {
    private ApkModule apkModule;

    @Override
    public void buildResources(File mainDirectory) throws IOException {
        this.scanManifest(mainDirectory);
        this.scanTable(mainDirectory);
        this.scanResJsonDirs(mainDirectory);
    }

    @Override
    public ApkModule getApkModule() {
        if (this.apkModule == null) {
            this.apkModule = new ApkModule();
            this.apkModule.setLoadDefaultFramework(false);
            this.apkModule.setAPKLogger(this.getApkLogger());
        }
        return this.apkModule;
    }

    private void scanResJsonDirs(File mainDirectory) {
        File resJsonDir = new File(mainDirectory, "res-json");
        List<File> jsonFileList = ApkUtil.recursiveFiles(resJsonDir);
        for (File file : jsonFileList) {
            this.scanResJsonFile(resJsonDir, file);
        }
    }

    private void scanResJsonFile(File resJsonDir, File file) {
        JsonXmlInputSource inputSource = JsonXmlInputSource.fromFile(resJsonDir, file);
        this.getApkModule().add(inputSource);
    }

    private void scanManifest(File mainDirectory) {
        File file = new File(mainDirectory, AndroidManifestBlock.FILE_NAME_JSON);
        if (!file.isFile()) {
            return;
        }
        JsonManifestInputSource inputSource = JsonManifestInputSource.fromFile(mainDirectory, file);
        inputSource.setAPKLogger(this.getApkLogger());
        this.getApkModule().add(inputSource);
    }

    private void scanTable(File mainDirectory) throws IOException {
        boolean singleFound = this.scanTableSingleJson(mainDirectory);
        if (singleFound) {
            this.logMessage("Building as single json");
            return;
        }
        boolean splitFound = this.scanTableSplitJson(mainDirectory);
        if (splitFound) {
            this.logMessage("Building as split json");
            return;
        }
        if (this.getApkModule().hasTableBlock()) {
            this.logMessage("WARN: Can not determine json type! Ignore building resource table");
            return;
        }
        throw new IOException("Can not determine json type! main directory '" + mainDirectory.getAbsolutePath() + "'");
    }

    private boolean scanTableSplitJson(File mainDirectory) {
        File resourcesDir = new File(mainDirectory, TableBlock.DIRECTORY_NAME);
        if (!resourcesDir.isDirectory()) {
            return false;
        }
        SplitJsonTableInputSource inputSource = new SplitJsonTableInputSource(resourcesDir);
        this.getApkModule().add(inputSource);
        return true;
    }

    private boolean scanTableSingleJson(File mainDirectory) {
        File resourcesDir = new File(mainDirectory, TableBlock.DIRECTORY_NAME);
        File file = new File(resourcesDir, TableBlock.JSON_FILE_NAME);
        if (!file.isFile()) {
            return false;
        }
        SingleJsonTableInputSource inputSource = SingleJsonTableInputSource.fromFile(resourcesDir, file);
        this.getApkModule().add(inputSource);
        return true;
    }
}

