/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleCoder;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.DexEncoder;
import com.reandroid.apk.DexFileRawEncoder;
import com.reandroid.apk.PathMap;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.app.AndroidManifest;
import com.reandroid.archive.ArchiveInfo;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.json.JSONArray;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class ApkModuleEncoder
extends ApkModuleCoder {
    private DexEncoder mDexEncoder;

    public void scanDirectory(File mainDirectory) throws IOException {
        this.logMessage("Scanning: " + mainDirectory.getName());
        this.encodeBinaryManifest(mainDirectory);
        this.loadArchiveInfo(mainDirectory);
        this.loadUncompressedFiles(mainDirectory);
        this.buildResources(mainDirectory);
        this.encodeDexFiles(mainDirectory);
        this.scanRootDir(mainDirectory);
        this.restorePathMap(mainDirectory);
        this.restoreSignatures(mainDirectory);
        this.sortFiles();
        this.refreshTable();
        this.dropEmptyManifest();
        this.dropNullTableBlock();
        this.onScanDirectoryComplete();
    }

    public void encodeBinaryManifest(File mainDirectory) {
        File file = new File(mainDirectory, AndroidManifestBlock.FILE_NAME_BIN);
        if (!file.isFile()) {
            return;
        }
        this.logMessage("Using binary xml: " + file.getName());
        FileInputSource inputSource = new FileInputSource(file, AndroidManifestBlock.FILE_NAME);
        this.getApkModule().add(inputSource);
    }

    public abstract void buildResources(File var1) throws IOException;

    @Override
    public abstract ApkModule getApkModule();

    void onScanDirectoryComplete() {
    }

    void refreshTable() {
        this.logMessage("Refreshing resource table ...");
        this.getApkModule().refreshTable();
        this.logMessage(this.getApkModule().getTableBlock().toString());
    }

    private void dropEmptyManifest() {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasAndroidManifest()) {
            return;
        }
        AndroidManifestBlock manifestBlock = apkModule.getAndroidManifest();
        ResXmlElement element = manifestBlock.getDocumentElement();
        if (element.equalsName(AndroidManifest.EMPTY_MANIFEST_TAG) && element.countElements() == 0) {
            apkModule.setManifest(null);
            this.logMessage("Removed empty: " + AndroidManifest.FILE_NAME);
        }
    }

    private void dropNullTableBlock() {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasTableBlock()) {
            return;
        }
        TableBlock loadedTableBlock = apkModule.getLoadedTableBlock();
        TableBlock tableBlock = loadedTableBlock;
        if (tableBlock == null) {
            tableBlock = apkModule.getTableBlock(false);
        }
        if (tableBlock.isEmpty() && tableBlock.isNull()) {
            apkModule.setTableBlock(null);
            this.logMessage("Removed empty: " + TableBlock.FILE_NAME);
        } else if (loadedTableBlock == null) {
            apkModule.discardTableBlockChanges();
        }
    }

    private void sortFiles() {
        this.logMessage("Sorting files ...");
        ZipEntryMap archive = this.getApkModule().getZipEntryMap();
        archive.autoSortApkFiles();
    }

    private void restoreSignatures(File mainDirectory) throws IOException {
        File sigDir = new File(mainDirectory, "signatures");
        if (!sigDir.isDirectory()) {
            return;
        }
        this.logMessage("Loading signatures ...");
        ApkModule apkModule = this.getApkModule();
        ApkSignatureBlock signatureBlock = new ApkSignatureBlock();
        signatureBlock.scanSplitFiles(sigDir);
        apkModule.setApkSignatureBlock(signatureBlock);
    }

    private void restorePathMap(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "path-map.json");
        if (!file.isFile()) {
            return;
        }
        this.logMessage("Restoring original file paths ...");
        PathMap pathMap = new PathMap();
        JSONArray jsonArray = new JSONArray(file);
        pathMap.fromJson(jsonArray);
        pathMap.restore(this.getApkModule());
    }

    private void scanRootDir(File mainDirectory) {
        this.logMessage("Scanning root directory ...");
        File root = new File(mainDirectory, "root");
        ZipEntryMap archive = this.getApkModule().getZipEntryMap();
        List<File> rootFileList = ApkUtil.recursiveFiles(root);
        for (File file : rootFileList) {
            String path = ApkUtil.toArchivePath(root, file);
            FileInputSource inputSource = new FileInputSource(file, path);
            archive.add(inputSource);
        }
    }

    public void encodeDexFiles(File mainDirectory) throws IOException {
        this.logMessage("Building dex ...");
        List<InputSource> dexList = this.getRawDexEncoder().buildDexFiles(this, mainDirectory);
        ApkModule apkModule = this.getApkModule();
        apkModule.addAll(dexList);
        DexEncoder dexEncoder = this.getDexEncoder();
        if (dexEncoder != null) {
            dexList = dexEncoder.buildDexFiles(this, mainDirectory);
            apkModule.addAll(dexList);
        }
    }

    public DexEncoder getRawDexEncoder() {
        DexFileRawEncoder dexFileRawEncoder = new DexFileRawEncoder();
        dexFileRawEncoder.setApkLogger(this.getApkLogger());
        return dexFileRawEncoder;
    }

    public DexEncoder getDexEncoder() {
        return this.mDexEncoder;
    }

    public void setDexEncoder(DexEncoder dexEncoder) {
        this.mDexEncoder = dexEncoder;
    }

    void loadArchiveInfo(File mainDirectory) throws IOException {
        ZipEntryMap zipEntryMap = this.getApkModule().getZipEntryMap();
        zipEntryMap.setArchiveInfo(ArchiveInfo.readJson(mainDirectory));
    }

    void loadUncompressedFiles(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "uncompressed-files.json");
        UncompressedFiles uncompressedFiles = this.getApkModule().getUncompressedFiles();
        uncompressedFiles.fromJson(file);
    }
}

