/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.AndroidFrameworks;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.archive.ArchiveBytes;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.WriteProgress;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.io.ArchiveFileEntrySource;
import com.reandroid.archive.writer.ApkByteWriter;
import com.reandroid.archive.writer.ApkFileWriter;
import com.reandroid.archive.writer.ApkStreamWriter;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.array.PackageArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.model.FrameworkTable;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class ApkModule
implements ApkFile,
Closeable {
    private String moduleName;
    private final ZipEntryMap zipEntryMap;
    private boolean loadDefaultFramework = true;
    private boolean mDisableLoadFramework = false;
    private TableBlock mTableBlock;
    private InputSource mTableOriginalSource;
    private AndroidManifestBlock mManifestBlock;
    private InputSource mManifestOriginalSource;
    private final UncompressedFiles mUncompressedFiles;
    private APKLogger apkLogger;
    private ApkFile.ApkType mApkType;
    private ApkSignatureBlock apkSignatureBlock;
    private Integer preferredFramework;
    private Closeable mCloseable;
    private final List<TableBlock> mExternalFrameworks;
    private final Map<Object, Object> mTagMaps;

    public ApkModule(String moduleName, ZipEntryMap zipEntryMap) {
        this.moduleName = moduleName;
        this.zipEntryMap = zipEntryMap;
        this.mUncompressedFiles = new UncompressedFiles();
        this.mUncompressedFiles.addPath(zipEntryMap);
        this.mExternalFrameworks = new ArrayCollection<TableBlock>();
        this.zipEntryMap.setModuleName(moduleName);
        this.mTagMaps = new HashMap<Object, Object>();
    }

    public ApkModule(ZipEntryMap zipEntryMap) {
        this("base", zipEntryMap);
    }

    public ApkModule() {
        this("base", new ZipEntryMap());
    }

    public void putTag(Object key, Object item) {
        this.mTagMaps.put(key, item);
    }

    public Object getTag(Object key) {
        return this.mTagMaps.get(key);
    }

    public Object removeTag(Object key) {
        return this.mTagMaps.remove(key);
    }

    public void clearTags() {
        this.mTagMaps.clear();
    }

    public void addExternalFramework(File frameworkFile) throws IOException {
        if (frameworkFile == null) {
            return;
        }
        this.logMessage("Loading external framework: " + frameworkFile);
        FrameworkApk framework = FrameworkApk.loadTableBlock(frameworkFile);
        framework.setAPKLogger(this.getApkLogger());
        this.addExternalFramework(framework);
    }

    public void addExternalFramework(ApkModule apkModule) {
        if (apkModule == null || apkModule == this || !apkModule.hasTableBlock()) {
            return;
        }
        this.addExternalFramework(apkModule.getTableBlock());
    }

    public void addExternalFramework(TableBlock tableBlock) {
        if (tableBlock == null || tableBlock.getApkFile() == this || this.mExternalFrameworks.contains(tableBlock)) {
            return;
        }
        this.mExternalFrameworks.add(tableBlock);
        this.updateExternalFramework();
    }

    public String refreshTable() {
        TableBlock tableBlock = this.mTableBlock;
        if (tableBlock != null) {
            return tableBlock.refreshFull();
        }
        return null;
    }

    public String refreshManifest() {
        AndroidManifestBlock manifestBlock = this.mManifestBlock;
        if (manifestBlock != null) {
            return manifestBlock.refreshFull();
        }
        return null;
    }

    public void validateResourceNames() {
        if (!this.hasTableBlock()) {
            return;
        }
        this.logMessage("Validating resource names ...");
        TableBlock tableBlock = this.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.validateResourceNames(packageBlock);
        }
    }

    public void validateResourceNames(PackageBlock packageBlock) {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.load(packageBlock);
        if (!packageIdentifier.hasDuplicateResources()) {
            return;
        }
        this.logMessage("Renaming duplicate resources ... ");
        packageIdentifier.ensureUniqueResourceNames();
        packageIdentifier.setResourceNamesToPackage(packageBlock);
    }

    public ApkSignatureBlock getApkSignatureBlock() {
        return this.apkSignatureBlock;
    }

    public void setApkSignatureBlock(ApkSignatureBlock apkSignatureBlock) {
        this.apkSignatureBlock = apkSignatureBlock;
    }

    public boolean hasSignatureBlock() {
        return this.getApkSignatureBlock() != null;
    }

    public void dumpSignatureInfoFiles(File directory) throws IOException {
        ApkSignatureBlock apkSignatureBlock = this.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            throw new IOException("Don't have signature block");
        }
        apkSignatureBlock.writeSplitRawToDirectory(directory);
    }

    public void dumpSignatureBlock(File file) throws IOException {
        ApkSignatureBlock apkSignatureBlock = this.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            throw new IOException("Don't have signature block");
        }
        apkSignatureBlock.writeRaw(file);
    }

    public void scanSignatureInfoFiles(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException("No such directory: " + directory);
        }
        ApkSignatureBlock apkSignatureBlock = this.apkSignatureBlock;
        if (apkSignatureBlock == null) {
            apkSignatureBlock = new ApkSignatureBlock();
        }
        apkSignatureBlock.scanSplitFiles(directory);
        this.setApkSignatureBlock(apkSignatureBlock);
    }

    public void loadSignatureBlock(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("No such file: " + file);
        }
        ApkSignatureBlock apkSignatureBlock = this.apkSignatureBlock;
        if (apkSignatureBlock == null) {
            apkSignatureBlock = new ApkSignatureBlock();
        }
        apkSignatureBlock.read(file);
        this.setApkSignatureBlock(apkSignatureBlock);
    }

    public String getSplit() {
        if (!this.hasAndroidManifest()) {
            return null;
        }
        return this.getAndroidManifest().getSplit();
    }

    public List<TableBlock> getLoadedFrameworks() {
        ArrayCollection<TableBlock> results = new ArrayCollection<TableBlock>();
        if (!this.hasTableBlock()) {
            return results;
        }
        TableBlock tableBlock = this.getTableBlock(false);
        results.addAll(tableBlock.getFrameWorks());
        return results;
    }

    public boolean isFrameworkVersionLoaded(Integer version) {
        if (version == null) {
            return false;
        }
        for (TableBlock tableBlock : this.getLoadedFrameworks()) {
            FrameworkTable frame;
            if (!(tableBlock instanceof FrameworkTable) || !version.equals((frame = (FrameworkTable)tableBlock).getVersionCode())) continue;
            return true;
        }
        return false;
    }

    public FrameworkApk getLoadedFramework(Integer version, boolean onlyAndroid) {
        for (TableBlock tableBlock : this.getLoadedFrameworks()) {
            if (!(tableBlock instanceof FrameworkTable)) continue;
            FrameworkTable frame = (FrameworkTable)tableBlock;
            if (onlyAndroid && !this.isAndroid(frame) || version != null && !version.equals(frame.getVersionCode())) continue;
            return (FrameworkApk)frame.getApkFile();
        }
        return null;
    }

    public FrameworkApk initializeAndroidFramework(Integer version) throws IOException {
        TableBlock tableBlock = this.getTableBlock(false);
        return this.initializeAndroidFramework(tableBlock, version);
    }

    public FrameworkApk initializeAndroidFramework(TableBlock tableBlock, Integer version) throws IOException {
        FrameworkApk frameworkApk;
        if (this.mDisableLoadFramework || tableBlock == null || this.isAndroid(tableBlock)) {
            return null;
        }
        FrameworkApk exist = this.getLoadedFramework(version, true);
        if (exist != null) {
            return exist;
        }
        this.logMessage("Initializing android framework ...");
        if (version == null) {
            this.logMessage("Can not read framework version, loading latest");
            frameworkApk = AndroidFrameworks.getLatest();
        } else {
            this.logMessage("Loading android framework for version: " + version);
            frameworkApk = AndroidFrameworks.getBestMatch(version);
        }
        FrameworkTable frameworkTable = frameworkApk.getTableBlock();
        tableBlock.addFramework(frameworkTable);
        this.logMessage("Initialized framework: " + frameworkApk.getName() + " (" + frameworkApk.getVersionName() + ")");
        return frameworkApk;
    }

    public FrameworkApk initializeAndroidFramework(XMLDocument xmlDocument) throws IOException {
        if (this.preferredFramework != null) {
            return this.initializeAndroidFramework(this.preferredFramework);
        }
        if (this.isAndroidCoreApp(xmlDocument)) {
            this.logMessage("Looks framework itself, skip loading frameworks");
            return null;
        }
        Integer version = this.readVersionCode(xmlDocument);
        return this.initializeAndroidFramework(version);
    }

    private boolean isAndroid(TableBlock tableBlock) {
        if (tableBlock instanceof FrameworkTable) {
            FrameworkTable frameworkTable = (FrameworkTable)tableBlock;
            return frameworkTable.isAndroid();
        }
        return false;
    }

    private boolean isAndroidCoreApp(XMLDocument manifestDocument) {
        XMLElement root = manifestDocument.getDocumentElement();
        if (root == null) {
            return false;
        }
        if (!"android".equals(root.getAttributeValue("package"))) {
            return false;
        }
        String coreApp = root.getAttributeValue("coreApp");
        return "true".equals(coreApp);
    }

    private Integer readVersionCode(XMLDocument xmlDocument) {
        if (xmlDocument == null) {
            return null;
        }
        XMLElement manifestRoot = xmlDocument.getDocumentElement();
        if (manifestRoot == null) {
            this.logMessage("WARN: Manifest root not found");
            return null;
        }
        String versionString = manifestRoot.getAttributeValue("android:compileSdkVersion");
        Integer version = null;
        if (versionString != null) {
            version = this.safeParseInteger(versionString);
        }
        if (version == null && (versionString = manifestRoot.getAttributeValue("platformBuildVersionCode")) != null) {
            version = this.safeParseInteger(versionString);
        }
        Integer target = null;
        Iterator<XMLElement> iterator = manifestRoot.getElements(AndroidManifestBlock.TAG_uses_sdk);
        while (iterator.hasNext()) {
            XMLElement element = iterator.next();
            versionString = element.getAttributeValue("android:targetSdkVersion");
            if (versionString == null) continue;
            target = this.safeParseInteger(versionString);
        }
        if (version == null) {
            version = target;
        } else if (target != null && target > version) {
            version = target;
        }
        return version;
    }

    private Integer safeParseInteger(String versionString) {
        try {
            return Integer.parseInt(versionString);
        }
        catch (NumberFormatException exception) {
            this.logMessage("NumberFormatException on manifest version reading: '" + versionString + "': " + exception.getMessage());
            return null;
        }
    }

    public void setPreferredFramework(Integer version) {
        if (version != null && version.equals(this.preferredFramework)) {
            return;
        }
        this.preferredFramework = version;
        if (version == null || this.mTableBlock == null) {
            return;
        }
        if (this.isFrameworkVersionLoaded(version)) {
            return;
        }
        this.logMessage("Initializing preferred framework: " + version);
        this.mTableBlock.clearFrameworks();
        FrameworkApk frameworkApk = AndroidFrameworks.getBestMatch(version);
        AndroidFrameworks.setCurrent(frameworkApk);
        this.mTableBlock.addFramework(frameworkApk.getTableBlock());
        this.logMessage("Initialized framework: " + frameworkApk.getVersionCode());
    }

    public Integer getAndroidFrameworkVersion() {
        if (this.preferredFramework != null) {
            return this.preferredFramework;
        }
        if (!this.hasAndroidManifest()) {
            return null;
        }
        AndroidManifestBlock manifest = this.getAndroidManifest();
        Integer version = manifest.getCompileSdkVersion();
        if (version == null) {
            version = manifest.getPlatformBuildVersionCode();
        }
        Integer target = manifest.getTargetSdkVersion();
        if (version == null) {
            version = target;
        } else if (target != null && target > version) {
            version = target;
        }
        return version;
    }

    public void removeResFilesWithEntry(int resourceId) {
        this.removeResFilesWithEntry(resourceId, null, true);
    }

    public void removeResFilesWithEntry(int resourceId, ResConfig resConfig, boolean trimEntryArray) {
        List<Entry> removedList = this.removeResFiles(resourceId, resConfig);
        SpecTypePair specTypePair = null;
        for (Entry entry : removedList) {
            if (entry == null || entry.isNull()) continue;
            if (trimEntryArray && specTypePair == null) {
                specTypePair = entry.getTypeBlock().getParentSpecTypePair();
            }
            entry.setNull(true);
        }
        if (specTypePair != null) {
            specTypePair.removeNullEntries(resourceId);
        }
    }

    public List<Entry> removeResFiles(int resourceId) {
        return this.removeResFiles(resourceId, null);
    }

    public List<Entry> removeResFiles(int resourceId, ResConfig resConfig) {
        ArrayCollection<Entry> results = new ArrayCollection<Entry>();
        if (resourceId == 0 && resConfig == null) {
            return results;
        }
        List<ResFile> resFileList = this.listResFiles(resourceId, resConfig);
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        for (ResFile resFile : resFileList) {
            results.addAll(resFile.iterator());
            zipEntryMap.remove(resFile.getInputSource());
        }
        return results;
    }

    public XMLDocument decodeXMLFile(String path) throws IOException {
        PackageBlock packageBlock;
        ResXmlDocument resXmlDocument = this.loadResXmlDocument(path);
        AndroidManifestBlock manifest = this.getAndroidManifest();
        int pkgId = manifest.guessCurrentPackageId();
        if (pkgId != 0 && this.hasTableBlock() && (packageBlock = this.getTableBlock().pickOne(pkgId)) != null) {
            resXmlDocument.setPackageBlock(packageBlock);
        }
        return resXmlDocument.decodeToXml();
    }

    public List<DexFileInputSource> listDexFiles() {
        ArrayCollection<DexFileInputSource> results = new ArrayCollection<DexFileInputSource>();
        for (InputSource source : this.getInputSources()) {
            if (!DexFileInputSource.isDexName(source.getAlias())) continue;
            DexFileInputSource inputSource = source instanceof DexFileInputSource ? (DexFileInputSource)source : new DexFileInputSource(source.getAlias(), source);
            results.add(inputSource);
        }
        DexFileInputSource.sort(results);
        return results;
    }

    public boolean isBaseModule() {
        if (!this.hasAndroidManifest()) {
            return false;
        }
        try {
            AndroidManifestBlock manifest = this.getAndroidManifest();
            return !manifest.isSplit() && manifest.getMainActivity() != null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException();
        }
        this.moduleName = moduleName;
        this.zipEntryMap.setModuleName(moduleName);
    }

    public void writeApk(File file) throws IOException {
        this.writeApk(file, null);
    }

    public void writeApk(File file, WriteProgress progress) throws IOException {
        ApkFileWriter writer = this.createApkFileWriter(file);
        writer.setWriteProgress(progress);
        writer.write();
    }

    public byte[] writeApkBytes() throws IOException {
        ApkByteWriter writer = this.createApkByteWriter();
        writer.write();
        return writer.toByteArray();
    }

    public void writeApk(OutputStream outputStream) throws IOException {
        this.createApkStreamWriter(outputStream).write();
    }

    public ApkFileWriter createApkFileWriter(File file) throws IOException {
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        UncompressedFiles uf = this.getUncompressedFiles();
        uf.apply(zipEntryMap);
        ApkFileWriter writer = new ApkFileWriter(file, zipEntryMap.toArray(true));
        writer.setAPKLogger(this.getApkLogger());
        writer.setApkSignatureBlock(this.getApkSignatureBlock());
        writer.setArchiveInfo(zipEntryMap.getArchiveInfo());
        return writer;
    }

    public ApkByteWriter createApkByteWriter() {
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        UncompressedFiles uf = this.getUncompressedFiles();
        uf.apply(zipEntryMap);
        ApkByteWriter writer = new ApkByteWriter(zipEntryMap.toArray(true));
        writer.setAPKLogger(this.getApkLogger());
        writer.setApkSignatureBlock(this.getApkSignatureBlock());
        writer.setArchiveInfo(zipEntryMap.getArchiveInfo());
        return writer;
    }

    public ApkStreamWriter createApkStreamWriter(OutputStream outputStream) {
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        UncompressedFiles uf = this.getUncompressedFiles();
        uf.apply(zipEntryMap);
        ApkStreamWriter writer = new ApkStreamWriter(outputStream, zipEntryMap.toArray(true));
        writer.setAPKLogger(this.getApkLogger());
        writer.setApkSignatureBlock(this.getApkSignatureBlock());
        writer.setArchiveInfo(zipEntryMap.getArchiveInfo());
        return writer;
    }

    public void uncompressNonXmlResFiles() {
        for (ResFile resFile : this.listResFiles()) {
            if (resFile.isBinaryXml()) continue;
            resFile.getInputSource().setMethod(0);
        }
    }

    public UncompressedFiles getUncompressedFiles() {
        return this.mUncompressedFiles;
    }

    public void removeDir(String dirName) {
        this.getZipEntryMap().removeDir(dirName);
    }

    public void validateResourcesDir() {
        List<ResFile> resFileList = this.listResFiles();
        HashSet<String> existPaths = new HashSet<String>();
        InputSource[] sourceList = this.getInputSources();
        for (InputSource inputSource : sourceList) {
            existPaths.add(inputSource.getAlias());
        }
        for (ResFile resFile : resFileList) {
            String path = resFile.getFilePath();
            String pathNew = resFile.validateTypeDirectoryName();
            if (pathNew == null || pathNew.equals(path) || existPaths.contains(pathNew)) continue;
            existPaths.remove(path);
            existPaths.add(pathNew);
            resFile.setFilePath(pathNew);
            if (resFile.getInputSource().getMethod() == 0) {
                this.getUncompressedFiles().replacePath(path, pathNew);
            }
            this.logVerbose("Dir validated: '" + path + "' -> '" + pathNew + "'");
        }
        TableStringPool stringPool = this.getTableBlock().getStringPool();
        stringPool.refreshUniqueIdMap();
        this.getTableBlock().refresh();
    }

    public void setResourcesRootDir(String dirName) {
        List<ResFile> resFileList = this.listResFiles();
        HashSet<String> existPaths = new HashSet<String>();
        InputSource[] sourceList = this.getInputSources();
        for (InputSource inputSource : sourceList) {
            existPaths.add(inputSource.getAlias());
        }
        for (ResFile resFile : resFileList) {
            String path = resFile.getFilePath();
            String pathNew = ApkUtil.replaceRootDir(path, dirName);
            if (existPaths.contains(pathNew)) continue;
            existPaths.remove(path);
            existPaths.add(pathNew);
            resFile.setFilePath(pathNew);
            if (resFile.getInputSource().getMethod() == 0) {
                this.getUncompressedFiles().replacePath(path, pathNew);
            }
            this.logVerbose("Root changed: '" + path + "' -> '" + pathNew + "'");
        }
        TableStringPool stringPool = this.getTableBlock().getStringPool();
        stringPool.refreshUniqueIdMap();
        this.getTableBlock().refresh();
    }

    public List<ResFile> listResFiles() {
        return this.listResFiles(0, null);
    }

    public List<ResFile> listResFiles(int resourceId, ResConfig resConfig) {
        ArrayCollection<ResFile> results = new ArrayCollection<ResFile>();
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock == null) {
            return results;
        }
        TableStringPool stringPool = tableBlock.getStringPool();
        for (InputSource inputSource : this.getInputSources()) {
            String name = inputSource.getAlias();
            Iterator iterator = stringPool.getItems(name);
            while (iterator.hasNext()) {
                TableString tableString = (TableString)iterator.next();
                List<Entry> entryList = this.filterResFileEntries(tableString, resourceId, resConfig);
                if (entryList.isEmpty()) continue;
                ResFile resFile = new ResFile(inputSource, entryList);
                results.add(resFile);
            }
        }
        return results;
    }

    public boolean removeResFile(String path) {
        return this.removeResFile(path, true);
    }

    public boolean removeResFile(String path, boolean keepResourceId) {
        InputSource inputSource = this.getInputSource(path);
        if (inputSource == null) {
            return false;
        }
        ResFile resFile = this.getResFile(path);
        if (resFile == null) {
            return false;
        }
        resFile.delete(keepResourceId);
        this.removeInputSource(path);
        return true;
    }

    public ResFile getResFile(String path) {
        InputSource inputSource = this.getInputSource(path);
        if (inputSource == null) {
            return null;
        }
        List<Entry> entryList = this.listReferencedEntries(path);
        if (entryList.isEmpty()) {
            return null;
        }
        return new ResFile(inputSource, entryList);
    }

    public List<Entry> listReferencedEntries(String path) {
        ArrayCollection<Entry> results = new ArrayCollection<Entry>();
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock != null) {
            TableStringPool stringPool = tableBlock.getStringPool();
            Iterator iterator = stringPool.getItems(path);
            Predicate<Entry> filter = entry -> entry.isScalar() && TypeBlock.canHaveResourceFile(entry.getTypeName());
            while (iterator.hasNext()) {
                results.addAll(((TableString)iterator.next()).getEntries(filter));
            }
        }
        return results;
    }

    private List<Entry> filterResFileEntries(TableString tableString, int resourceId, ResConfig resConfig) {
        Iterator<Entry> itr = tableString.getEntries(item -> {
            if (!item.isScalar() || !TypeBlock.canHaveResourceFile(item.getTypeName())) {
                return false;
            }
            if (resourceId != 0 && resourceId != item.getResourceId()) {
                return false;
            }
            return resConfig == null || resConfig.equals(item.getResConfig());
        });
        return CollectionUtil.toList(itr);
    }

    public String getPackageName() {
        if (this.hasAndroidManifest()) {
            return this.getAndroidManifest().getPackageName();
        }
        if (!this.hasTableBlock()) {
            return null;
        }
        TableBlock tableBlock = this.getTableBlock();
        PackageArray pkgArray = tableBlock.getPackageArray();
        PackageBlock pkg = (PackageBlock)pkgArray.get(0);
        if (pkg == null) {
            return null;
        }
        return pkg.getName();
    }

    public void setPackageName(String name) {
        String old = this.getPackageName();
        if (this.hasAndroidManifest()) {
            this.getAndroidManifest().setPackageName(name);
        }
        if (!this.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = this.getTableBlock();
        PackageArray pkgArray = tableBlock.getPackageArray();
        for (PackageBlock pkg : pkgArray.listItems()) {
            if (pkgArray.size() == 1) {
                pkg.setName(name);
                continue;
            }
            String pkgName = pkg.getName();
            if (!pkgName.startsWith(old)) continue;
            pkgName = pkgName.replace(old, name);
            pkg.setName(pkgName);
        }
    }

    @Deprecated
    public boolean hasAndroidManifestBlock() {
        return this.hasAndroidManifest();
    }

    public boolean hasAndroidManifest() {
        return this.mManifestBlock != null || this.getZipEntryMap().getInputSource(AndroidManifestBlock.FILE_NAME) != null;
    }

    public boolean hasTableBlock() {
        return this.mTableBlock != null || this.getZipEntryMap().getInputSource(TableBlock.FILE_NAME) != null;
    }

    public void destroy() {
        TableBlock tableBlock;
        this.getZipEntryMap().clear();
        AndroidManifestBlock manifestBlock = this.mManifestBlock;
        if (manifestBlock != null) {
            manifestBlock.destroy();
            this.mManifestBlock = null;
        }
        if ((tableBlock = this.mTableBlock) != null) {
            this.mExternalFrameworks.clear();
            tableBlock.clear();
            this.mTableBlock = null;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setManifest(AndroidManifestBlock manifestBlock) {
        ZipEntryMap archive = this.getZipEntryMap();
        if (manifestBlock == null) {
            this.mManifestBlock = null;
            this.mManifestOriginalSource = null;
            archive.remove(AndroidManifestBlock.FILE_NAME);
            return;
        }
        manifestBlock.setApkFile(this);
        BlockInputSource<AndroidManifestBlock> source = new BlockInputSource<AndroidManifestBlock>(AndroidManifestBlock.FILE_NAME, manifestBlock);
        source.setMethod(0);
        source.setSort(0);
        archive.add(source);
        this.mManifestBlock = manifestBlock;
    }

    public void setTableBlock(TableBlock tableBlock) {
        ZipEntryMap archive = this.getZipEntryMap();
        if (tableBlock == null) {
            this.mTableBlock = null;
            this.mTableOriginalSource = null;
            archive.remove(TableBlock.FILE_NAME);
            return;
        }
        tableBlock.setApkFile(this);
        BlockInputSource<TableBlock> source = new BlockInputSource<TableBlock>(TableBlock.FILE_NAME, tableBlock);
        archive.add(source);
        source.setMethod(0);
        source.setSort(1);
        this.getUncompressedFiles().addPath(source);
        this.mTableBlock = tableBlock;
        this.updateExternalFramework();
    }

    @Deprecated
    public AndroidManifestBlock getAndroidManifestBlock() {
        return this.getAndroidManifest();
    }

    @Override
    public AndroidManifestBlock getAndroidManifest() {
        if (this.mManifestBlock != null) {
            return this.mManifestBlock;
        }
        InputSource inputSource = this.getInputSource(AndroidManifestBlock.FILE_NAME);
        if (inputSource == null) {
            return null;
        }
        this.setManifestOriginalSource(inputSource);
        InputStream inputStream = null;
        try {
            inputStream = inputSource.openStream();
            AndroidManifestBlock manifestBlock = AndroidManifestBlock.load(inputStream);
            inputStream.close();
            BlockInputSource<AndroidManifestBlock> blockInputSource = new BlockInputSource<AndroidManifestBlock>(inputSource.getName(), manifestBlock);
            blockInputSource.setSort(inputSource.getSort());
            blockInputSource.setMethod(inputSource.getMethod());
            this.addInputSource(blockInputSource);
            manifestBlock.setApkFile(this);
            TableBlock tableBlock = this.mTableBlock;
            if (tableBlock != null) {
                int packageId = manifestBlock.guessCurrentPackageId();
                if (packageId != 0) {
                    manifestBlock.setPackageBlock(tableBlock.pickOne(packageId));
                } else {
                    manifestBlock.setPackageBlock(tableBlock.pickOne());
                }
            }
            this.mManifestBlock = manifestBlock;
            this.onManifestBlockLoaded(manifestBlock);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
        return this.mManifestBlock;
    }

    private void onManifestBlockLoaded(AndroidManifestBlock manifestBlock) {
        this.initializeApkType(manifestBlock);
    }

    public TableBlock getTableBlock(boolean initFramework) {
        if (this.mTableBlock == null) {
            if (!this.hasTableBlock()) {
                return null;
            }
            try {
                this.mTableBlock = this.loadTableBlock();
                if (initFramework && this.loadDefaultFramework) {
                    Integer version = this.getAndroidFrameworkVersion();
                    this.initializeAndroidFramework(this.mTableBlock, version);
                }
                this.updateExternalFramework();
            }
            catch (IOException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        return this.mTableBlock;
    }

    private void updateExternalFramework() {
        TableBlock tableBlock = this.mTableBlock;
        if (tableBlock == null) {
            return;
        }
        for (TableBlock framework : this.mExternalFrameworks) {
            tableBlock.addFramework(framework);
        }
    }

    public void discardManifestChanges() {
        this.getZipEntryMap().add(this.getManifestOriginalSource());
    }

    public void keepManifestChanges() {
        this.mManifestOriginalSource = null;
    }

    public InputSource getManifestOriginalSource() {
        InputSource inputSource = this.mManifestOriginalSource;
        if (inputSource == null) {
            this.mManifestOriginalSource = inputSource = this.getInputSource(AndroidManifestBlock.FILE_NAME);
        }
        return inputSource;
    }

    private void setManifestOriginalSource(InputSource inputSource) {
        if (this.mManifestOriginalSource == null && !(inputSource instanceof BlockInputSource)) {
            this.mManifestOriginalSource = inputSource;
        }
    }

    public void discardTableBlockChanges() {
        this.getZipEntryMap().add(this.getTableOriginalSource());
    }

    public void keepTableBlockChanges() {
        this.mTableOriginalSource = null;
    }

    public InputSource getTableOriginalSource() {
        InputSource inputSource = this.mTableOriginalSource;
        if (inputSource == null) {
            this.mTableOriginalSource = inputSource = this.getInputSource(TableBlock.FILE_NAME);
        }
        return inputSource;
    }

    private void setTableOriginalSource(InputSource inputSource) {
        if (this.mTableOriginalSource == null && !(inputSource instanceof BlockInputSource)) {
            this.mTableOriginalSource = inputSource;
        }
    }

    @Override
    public TableBlock getTableBlock() {
        if (this.mTableBlock != null) {
            return this.mTableBlock;
        }
        this.checkExternalFramework();
        this.checkSelfFramework();
        return this.getTableBlock(!this.mDisableLoadFramework);
    }

    @Override
    public TableBlock getLoadedTableBlock() {
        return this.mTableBlock;
    }

    private void checkExternalFramework() {
        if (this.mDisableLoadFramework || this.preferredFramework != null) {
            return;
        }
        if (this.mExternalFrameworks.size() == 0) {
            return;
        }
        this.mDisableLoadFramework = true;
    }

    private void checkSelfFramework() {
        if (this.mDisableLoadFramework || this.preferredFramework != null) {
            return;
        }
        AndroidManifestBlock manifest = this.getAndroidManifest();
        if (manifest == null) {
            return;
        }
        if (manifest.isCoreApp() == null || !"android".equals(manifest.getPackageName())) {
            return;
        }
        if (manifest.guessCurrentPackageId() != 1) {
            return;
        }
        this.logMessage("Looks like framework apk, skip loading framework");
        this.mDisableLoadFramework = true;
    }

    @Override
    public ResXmlDocument getResXmlDocument(String path) {
        InputSource inputSource = this.getInputSource(path);
        if (inputSource != null) {
            try {
                return this.loadResXmlDocument(inputSource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ResXmlDocument loadResXmlDocument(String path) throws IOException {
        InputSource inputSource = this.getInputSource(path);
        if (inputSource == null) {
            throw new FileNotFoundException("No such file in apk: " + path);
        }
        return this.loadResXmlDocument(inputSource);
    }

    public ResXmlDocument loadResXmlDocument(InputSource inputSource) throws IOException {
        Object block;
        ResXmlDocument resXmlDocument = null;
        if (inputSource instanceof BlockInputSource && (block = ((BlockInputSource)inputSource).getBlock()) instanceof ResXmlDocument) {
            resXmlDocument = (ResXmlDocument)block;
        }
        if (resXmlDocument == null) {
            resXmlDocument = new ResXmlDocument();
            resXmlDocument.readBytes(inputSource.openStream());
        }
        resXmlDocument.setApkFile(this);
        if (resXmlDocument.getPackageBlock() == null) {
            resXmlDocument.setPackageBlock(this.findPackageForPath(inputSource.getAlias()));
        }
        return resXmlDocument;
    }

    private PackageBlock findPackageForPath(String path) {
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        if (tableBlock.size() == 1) {
            return tableBlock.get(0);
        }
        PackageBlock packageBlock = CollectionUtil.getFirst(tableBlock.getStringPool().getUsers(PackageBlock.class, path));
        if (packageBlock == null) {
            packageBlock = tableBlock.pickOne();
        }
        return packageBlock;
    }

    public ApkFile.ApkType getApkType() {
        if (this.mApkType != null) {
            return this.mApkType;
        }
        return this.initializeApkType(this.mManifestBlock);
    }

    public void setApkType(ApkFile.ApkType apkType) {
        this.mApkType = apkType;
    }

    private ApkFile.ApkType initializeApkType(AndroidManifestBlock manifestBlock) {
        if (this.mApkType != null) {
            return this.mApkType;
        }
        ApkFile.ApkType apkType = null;
        if (manifestBlock != null) {
            apkType = manifestBlock.guessApkType();
        }
        if (apkType != null) {
            this.mApkType = apkType;
        } else {
            apkType = ApkFile.ApkType.UNKNOWN;
        }
        return apkType;
    }

    public TableStringPool getVolatileTableStringPool() throws IOException {
        if (this.mTableBlock != null) {
            return this.mTableBlock.getStringPool();
        }
        InputSource inputSource = this.getInputSource(TableBlock.FILE_NAME);
        if (inputSource == null) {
            throw new IOException("Module don't have: " + TableBlock.FILE_NAME);
        }
        if (inputSource instanceof ArchiveFileEntrySource || inputSource instanceof FileInputSource) {
            InputStream inputStream = inputSource.openStream();
            TableStringPool stringPool = TableStringPool.readFromTable(inputStream);
            inputStream.close();
            return stringPool;
        }
        return this.getTableBlock().getStringPool();
    }

    TableBlock loadTableBlock() throws IOException {
        TableBlock tableBlock;
        InputSource inputSource = this.getInputSource(TableBlock.FILE_NAME);
        if (inputSource == null) {
            throw new IOException("Entry not found: " + TableBlock.FILE_NAME);
        }
        if (inputSource instanceof BlockInputSource) {
            tableBlock = (TableBlock)((BlockInputSource)inputSource).getBlock();
        } else {
            this.setTableOriginalSource(inputSource);
            InputStream inputStream = inputSource.openStream();
            tableBlock = TableBlock.load(inputStream);
            inputStream.close();
        }
        BlockInputSource<TableBlock> blockInputSource = new BlockInputSource<TableBlock>(inputSource.getName(), tableBlock);
        blockInputSource.setMethod(inputSource.getMethod());
        blockInputSource.setSort(inputSource.getSort());
        this.getZipEntryMap().add(blockInputSource);
        tableBlock.setApkFile(this);
        return tableBlock;
    }

    @Override
    public void add(InputSource inputSource) {
        if (inputSource == null) {
            return;
        }
        String path = inputSource.getAlias();
        if (AndroidManifestBlock.FILE_NAME.equals(path)) {
            InputSource manifestSource = this.getManifestOriginalSource();
            if (manifestSource != inputSource) {
                this.mManifestBlock = null;
            }
            this.setManifestOriginalSource(inputSource);
        } else if (TableBlock.FILE_NAME.equals(path)) {
            InputSource table = this.getTableOriginalSource();
            if (inputSource != table) {
                this.mTableBlock = null;
            }
            this.setTableOriginalSource(inputSource);
        }
        this.addInputSource(inputSource);
    }

    @Override
    public boolean containsFile(String path) {
        return this.getZipEntryMap().contains(path);
    }

    @Override
    public InputSource getInputSource(String path) {
        return this.getZipEntryMap().getInputSource(path);
    }

    public InputSource removeInputSource(String path) {
        return this.getZipEntryMap().remove(path);
    }

    private void addInputSource(InputSource inputSource) {
        this.getZipEntryMap().add(inputSource);
    }

    public List<InputSource> listInputSources() {
        return this.getZipEntryMap().listInputSources();
    }

    public InputSource[] getInputSources() {
        return this.getZipEntryMap().toArray();
    }

    public ZipEntryMap getZipEntryMap() {
        return this.zipEntryMap;
    }

    public void setLoadDefaultFramework(boolean loadDefaultFramework) {
        this.loadDefaultFramework = loadDefaultFramework;
        this.mDisableLoadFramework = !loadDefaultFramework;
    }

    public void merge(ApkModule module) throws IOException {
        if (module == null || module == this) {
            return;
        }
        this.logMessage("Merging: " + module.getModuleName());
        this.mergeDexFiles(module);
        this.mergeTable(module);
        this.mergeFiles(module);
        this.getUncompressedFiles().merge(module.getUncompressedFiles());
    }

    private void mergeTable(ApkModule module) {
        TableBlock exist;
        if (!module.hasTableBlock()) {
            return;
        }
        this.logMessage("Merging resource table: " + module.getModuleName());
        if (!this.hasTableBlock()) {
            exist = new TableBlock();
            BlockInputSource<TableBlock> inputSource = new BlockInputSource<TableBlock>(TableBlock.FILE_NAME, exist);
            this.addInputSource(inputSource);
        } else {
            exist = this.getTableBlock();
        }
        TableBlock coming = module.getTableBlock();
        exist.merge(coming);
    }

    private void mergeFiles(ApkModule module) {
        ZipEntryMap entryMapExist = this.getZipEntryMap();
        ZipEntryMap entryMapComing = module.getZipEntryMap();
        LinkedHashMap<String, InputSource> comingAlias = entryMapComing.toAliasMap();
        LinkedHashMap<String, InputSource> existAlias = entryMapExist.toAliasMap();
        UncompressedFiles uncompressedFiles = module.getUncompressedFiles();
        for (InputSource inputSource : comingAlias.values()) {
            if (existAlias.containsKey(inputSource.getAlias()) || existAlias.containsKey(inputSource.getName()) || DexFileInputSource.isDexName(inputSource.getName())) continue;
            if (inputSource.getAlias().startsWith("lib/")) {
                uncompressedFiles.removePath(inputSource.getAlias());
            }
            this.logVerbose("Added: " + inputSource.getAlias());
            entryMapExist.add(inputSource);
        }
    }

    private void mergeDexFiles(ApkModule module) {
        UncompressedFiles uncompressedFiles = module.getUncompressedFiles();
        List<DexFileInputSource> existList = this.listDexFiles();
        List<DexFileInputSource> comingList = module.listDexFiles();
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        int index = 0;
        if (existList.size() > 0) {
            index = existList.get(existList.size() - 1).getDexNumber();
            index = index == 0 ? 2 : ++index;
        }
        for (DexFileInputSource source : comingList) {
            uncompressedFiles.removePath(source.getAlias());
            String name = DexFileInputSource.getDexName(index);
            DexFileInputSource add = new DexFileInputSource(name, (InputSource)source.getInputSource());
            zipEntryMap.add(add);
            this.logMessage("Added [" + module.getModuleName() + "] " + source.getAlias() + " -> " + name);
            if (++index != 1) continue;
            index = 2;
        }
    }

    public APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }

    public void setCloseable(Closeable closeable) {
        this.mCloseable = closeable;
    }

    @Override
    public void close() throws IOException {
        Closeable closeable = this.mCloseable;
        if (closeable != null) {
            closeable.close();
        }
    }

    public String toString() {
        return this.getModuleName();
    }

    public static ApkModule loadApkFile(File apkFile) throws IOException {
        return ApkModule.loadApkFile(apkFile, "base");
    }

    public static ApkModule loadApkFile(File apkFile, String moduleName) throws IOException {
        ArchiveFile archive = new ArchiveFile(apkFile);
        ApkModule apkModule = new ApkModule(moduleName, archive.createZipEntryMap());
        apkModule.setApkSignatureBlock(archive.getApkSignatureBlock());
        apkModule.setCloseable(archive);
        return apkModule;
    }

    public static ApkModule loadApkFile(File apkFile, File ... externalFrameworks) throws IOException {
        return ApkModule.loadApkFile(null, apkFile, externalFrameworks);
    }

    public static ApkModule loadApkFile(APKLogger logger, File apkFile, File ... externalFrameworks) throws IOException {
        ArchiveFile archive = new ArchiveFile(apkFile);
        ApkModule apkModule = new ApkModule("base", archive.createZipEntryMap());
        apkModule.setAPKLogger(logger);
        apkModule.setApkSignatureBlock(archive.getApkSignatureBlock());
        apkModule.setCloseable(archive);
        if (externalFrameworks == null || externalFrameworks.length == 0) {
            return apkModule;
        }
        for (File frameworkFile : externalFrameworks) {
            if (frameworkFile == null) continue;
            if (apkFile.equals(frameworkFile)) {
                throw new IOException("External framework should be different: " + apkFile);
            }
            apkModule.addExternalFramework(frameworkFile);
        }
        return apkModule;
    }

    public static ApkModule readApkBytes(byte[] bytes) throws IOException {
        ArchiveBytes archiveBytes = new ArchiveBytes(bytes);
        ApkModule apkModule = new ApkModule(archiveBytes.createZipEntryMap());
        apkModule.setModuleName("byte_" + System.currentTimeMillis());
        return apkModule;
    }
}

